/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import universum.studios.android.fragment.util.FragmentUtils;

public abstract class ActionBarDelegate {
    @NonNull
    final Context context;

    protected ActionBarDelegate(@NonNull Context context) {
        this.context = context;
    }

    @Nullable
    public static ActionBarDelegate create(@NonNull Activity activity) {
        if (activity instanceof AppCompatActivity) {
            androidx.appcompat.app.ActionBar actionBar = ((AppCompatActivity)activity).getSupportActionBar();
            return actionBar == null ? null : ActionBarDelegate.create((Context)activity, actionBar);
        }
        ActionBar actionBar = activity.getActionBar();
        return actionBar == null ? null : ActionBarDelegate.create((Context)activity, actionBar);
    }

    @NonNull
    public static ActionBarDelegate create(@NonNull Context context, @Nullable ActionBar actionBar) {
        return new Impl(context, actionBar);
    }

    @NonNull
    public static ActionBarDelegate create(@NonNull Context context, @Nullable androidx.appcompat.app.ActionBar actionBar) {
        return new SupportImpl(context, actionBar);
    }

    @NonNull
    protected Context getContext() {
        return this.context;
    }

    public abstract void setDisplayHomeAsUpEnabled(boolean var1);

    public abstract void setHomeAsUpIndicator(@DrawableRes int var1);

    public abstract void setHomeAsUpVectorIndicator(@DrawableRes int var1);

    public abstract void setHomeAsUpIndicator(@Nullable Drawable var1);

    public abstract void setIcon(@DrawableRes int var1);

    public abstract void setIcon(@Nullable Drawable var1);

    public abstract void setTitle(@StringRes int var1);

    public abstract void setTitle(@Nullable CharSequence var1);

    @VisibleForTesting
    static final class SupportImpl
    extends ActionBarDelegate {
        private final androidx.appcompat.app.ActionBar actionBar;

        SupportImpl(Context context, androidx.appcompat.app.ActionBar actionBar) {
            super(context);
            this.actionBar = actionBar;
        }

        @Override
        public void setDisplayHomeAsUpEnabled(boolean enabled) {
            if (this.actionBar != null) {
                this.actionBar.setDisplayHomeAsUpEnabled(enabled);
            }
        }

        @Override
        public void setHomeAsUpIndicator(@DrawableRes int resId) {
            if (this.actionBar != null) {
                this.actionBar.setHomeAsUpIndicator(resId);
            }
        }

        @Override
        public void setHomeAsUpVectorIndicator(@DrawableRes int resId) {
            this.setHomeAsUpIndicator(FragmentUtils.getVectorDrawable(this.context.getResources(), resId, this.context.getTheme()));
        }

        @Override
        public void setHomeAsUpIndicator(@Nullable Drawable indicator) {
            if (this.actionBar != null) {
                this.actionBar.setHomeAsUpIndicator(indicator);
            }
        }

        @Override
        public void setIcon(@DrawableRes int resId) {
            if (this.actionBar != null) {
                this.actionBar.setIcon(resId);
            }
        }

        @Override
        public void setIcon(@Nullable Drawable icon) {
            if (this.actionBar != null) {
                this.actionBar.setIcon(icon);
            }
        }

        @Override
        public void setTitle(@StringRes int resId) {
            this.setTitle(this.context.getText(resId));
        }

        @Override
        public void setTitle(@Nullable CharSequence title) {
            if (this.actionBar != null) {
                this.actionBar.setTitle(title);
            }
        }
    }

    @VisibleForTesting
    static final class Impl
    extends ActionBarDelegate {
        private final ActionBar actionBar;

        Impl(Context context, ActionBar actionBar) {
            super(context);
            this.actionBar = actionBar;
        }

        @Override
        public void setDisplayHomeAsUpEnabled(boolean enabled) {
            if (this.actionBar != null) {
                this.actionBar.setDisplayHomeAsUpEnabled(enabled);
            }
        }

        @Override
        public void setHomeAsUpIndicator(@DrawableRes int resId) {
            if (this.actionBar != null && Build.VERSION.SDK_INT >= 18) {
                this.actionBar.setHomeAsUpIndicator(resId);
            }
        }

        @Override
        public void setHomeAsUpVectorIndicator(@DrawableRes int resId) {
            this.setHomeAsUpIndicator(FragmentUtils.getVectorDrawable(this.context.getResources(), resId, this.context.getTheme()));
        }

        @Override
        public void setHomeAsUpIndicator(@Nullable Drawable indicator) {
            if (this.actionBar != null && Build.VERSION.SDK_INT >= 18) {
                this.actionBar.setHomeAsUpIndicator(indicator);
            }
        }

        @Override
        public void setTitle(@StringRes int resId) {
            this.setTitle(this.context.getText(resId));
        }

        @Override
        public void setTitle(@Nullable CharSequence title) {
            if (this.actionBar != null) {
                this.actionBar.setTitle(title);
            }
        }

        @Override
        public void setIcon(@DrawableRes int resId) {
            if (this.actionBar != null && Build.VERSION.SDK_INT >= 14) {
                this.actionBar.setIcon(resId);
            }
        }

        @Override
        public void setIcon(@Nullable Drawable icon) {
            if (this.actionBar != null && Build.VERSION.SDK_INT >= 14) {
                this.actionBar.setIcon(icon);
            }
        }
    }
}

