/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.annotation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FragmentAnnotations {
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    private FragmentAnnotations() {
        throw new UnsupportedOperationException();
    }

    public static void setEnabled(boolean enabled) {
        FragmentAnnotations.enabled.set(enabled);
    }

    public static boolean isEnabled() {
        return enabled.get();
    }

    public static void checkIfEnabledOrThrow() {
        if (!enabled.get()) {
            throw new IllegalStateException("Trying to access logic that requires annotations processing to be enabled, but it appears that the annotations processing is disabled for the Fragments library.");
        }
    }

    @Nullable
    public static <A extends Annotation> A obtainAnnotationFrom(@NonNull Class<A> classOfAnnotation, @NonNull Class<?> fromClass, @Nullable Class<?> maxSuperClass) {
        Class<?> parent;
        A annotation = fromClass.getAnnotation(classOfAnnotation);
        if (annotation != null) {
            return annotation;
        }
        if (maxSuperClass != null && (parent = fromClass.getSuperclass()) != null && !parent.equals(maxSuperClass)) {
            return FragmentAnnotations.obtainAnnotationFrom(classOfAnnotation, parent, maxSuperClass);
        }
        return null;
    }

    public static void iterateFields(@NonNull FieldProcessor processor, @NonNull Class<?> ofClass, @Nullable Class<?> maxSuperClass) {
        Class<?> parent;
        Field[] fields = ofClass.getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                processor.onProcessField(field, field.getName());
            }
        }
        if (maxSuperClass != null && (parent = ofClass.getSuperclass()) != null && !parent.equals(maxSuperClass)) {
            FragmentAnnotations.iterateFields(processor, parent, maxSuperClass);
        }
    }

    public static interface FieldProcessor {
        public void onProcessField(@NonNull Field var1, @NonNull String var2);
    }
}

