/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.manage;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.util.Pair;
import androidx.fragment.app.Fragment;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.fragment.manage.FragmentController;
import universum.studios.android.fragment.manage.FragmentTransition;

public final class FragmentRequest {
    public static final int NO_ID = -1;
    public static final int NO_STYLE = -1;
    public static final int REPLACE = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int SHOW = 3;
    public static final int HIDE = 4;
    public static final int ATTACH = 5;
    public static final int DETACH = 6;
    static final int REPLACE_SAME = 1;
    static final int ADD_TO_BACK_STACK = 2;
    static final int ALLOW_STATE_LOSS = 4;
    static final int IMMEDIATE = 8;
    static final int TRANSITION_ENTER = 1;
    static final int TRANSITION_EXIT = 2;
    static final int TRANSITION_REENTER = 4;
    static final int TRANSITION_RETURN = 8;
    static final int TRANSITION_SHARED_ELEMENT_ENTER = 16;
    static final int TRANSITION_SHARED_ELEMENT_RETURN = 32;
    private final FragmentController controller;
    Fragment fragment;
    int fragmentId = -1;
    private int outgoingFragmentId = -1;
    Bundle arguments;
    int transaction = 0;
    String tag;
    int viewContainerId = -1;
    FragmentTransition transition;
    int transitionStyle = -1;
    Object enterTransition;
    Object exitTransition;
    Object reenterTransition;
    Object returnTransition;
    Object sharedElementEnterTransition;
    Object sharedElementReturnTransition;
    private int specifiedTransitions;
    Boolean allowEnterTransitionOverlap;
    Boolean allowReturnTransitionOverlap;
    List<Pair<View, String>> sharedElements;
    private int flags;
    private boolean executed;

    FragmentRequest(FragmentController controller, int fragmentId) {
        this(controller, null);
        this.fragmentId = fragmentId;
    }

    FragmentRequest(FragmentController controller, Fragment fragment) {
        this.controller = controller;
        this.fragment = fragment;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("FragmentRequest{fragmentId: ");
        builder.append(this.fragmentId);
        builder.append(", outgoingFragmentId: ");
        builder.append(this.outgoingFragmentId);
        builder.append(", arguments: ");
        builder.append(this.arguments);
        builder.append(", transactionType: ");
        builder.append(this.transition);
        builder.append(", tag: ");
        builder.append(this.tag);
        builder.append(", viewContainerId: ");
        builder.append(this.viewContainerId);
        builder.append(", transition: ");
        builder.append(this.transition == null ? "null" : this.transition.getName());
        builder.append(", transitionStyle: ");
        builder.append(this.transitionStyle);
        builder.append(", replaceSame: ");
        builder.append(this.hasFlag(1));
        builder.append(", addToBackStack: ");
        builder.append(this.hasFlag(2));
        builder.append(", allowStateLoss: ");
        builder.append(this.hasFlag(4));
        builder.append(", immediate: ");
        builder.append(this.hasFlag(8));
        builder.append(", executed: ");
        builder.append(this.executed);
        return builder.append("}").toString();
    }

    @NonNull
    public Fragment fragment() {
        return this.fragment;
    }

    public FragmentRequest fragmentId(int fragmentId) {
        this.fragmentId = fragmentId;
        return this;
    }

    public int fragmentId() {
        return this.fragmentId;
    }

    public FragmentRequest outgoingFragmentId(int fragmentId) {
        this.outgoingFragmentId = fragmentId;
        return this;
    }

    public int outgoingFragmentId() {
        return this.outgoingFragmentId;
    }

    public FragmentRequest arguments(@Nullable Bundle arguments) {
        this.arguments = arguments;
        return this;
    }

    @Nullable
    public Bundle arguments() {
        return this.arguments;
    }

    public FragmentRequest transaction(int transaction) {
        this.transaction = transaction;
        return this;
    }

    public int transaction() {
        return this.transaction;
    }

    public FragmentRequest tag(@Nullable String fragmentTag) {
        this.tag = fragmentTag;
        return this;
    }

    @Nullable
    public String tag() {
        return this.tag;
    }

    public FragmentRequest viewContainerId(@IdRes int containerId) {
        this.viewContainerId = containerId;
        return this;
    }

    @IdRes
    public int viewContainerId() {
        return this.viewContainerId;
    }

    public FragmentRequest transition(@Nullable FragmentTransition transition) {
        this.transition = transition;
        return this;
    }

    @Nullable
    public FragmentTransition transition() {
        return this.transition;
    }

    public FragmentRequest transitionStyle(@StyleRes int transitionStyle) {
        this.transitionStyle = transitionStyle;
        return this;
    }

    @StyleRes
    public int transitionStyle() {
        return this.transitionStyle;
    }

    public FragmentRequest enterTransition(@Nullable Object transition) {
        this.specifiedTransitions |= 1;
        this.enterTransition = transition;
        return this;
    }

    @Nullable
    public Object enterTransition() {
        return this.enterTransition;
    }

    public FragmentRequest exitTransition(@Nullable Object transition) {
        this.specifiedTransitions |= 2;
        this.exitTransition = transition;
        return this;
    }

    @Nullable
    public Object exitTransition() {
        return this.exitTransition;
    }

    public FragmentRequest reenterTransition(@Nullable Object transition) {
        this.specifiedTransitions |= 4;
        this.reenterTransition = transition;
        return this;
    }

    @Nullable
    public Object reenterTransition() {
        return this.reenterTransition;
    }

    public FragmentRequest returnTransition(@Nullable Object transition) {
        this.specifiedTransitions |= 8;
        this.returnTransition = transition;
        return this;
    }

    @Nullable
    public Object returnTransition() {
        return this.returnTransition;
    }

    public FragmentRequest allowEnterTransitionOverlap(boolean allowOverlap) {
        this.allowEnterTransitionOverlap = allowOverlap;
        return this;
    }

    public Boolean allowEnterTransitionOverlap() {
        return this.allowEnterTransitionOverlap;
    }

    public FragmentRequest allowReturnTransitionOverlap(boolean allowOverlap) {
        this.allowReturnTransitionOverlap = allowOverlap;
        return this;
    }

    public Boolean allowReturnTransitionOverlap() {
        return this.allowReturnTransitionOverlap;
    }

    @SafeVarargs
    public final FragmentRequest sharedElements(Pair<View, String> ... elements) {
        if (this.sharedElements == null) {
            this.sharedElements = new ArrayList<Pair<View, String>>(elements.length);
        }
        this.sharedElements.addAll(Arrays.asList(elements));
        return this;
    }

    public FragmentRequest sharedElement(@NonNull View element, @NonNull String elementName) {
        if (this.sharedElements == null) {
            this.sharedElements = new ArrayList<Pair<View, String>>(1);
        }
        this.sharedElements.add((Pair<View, String>)new Pair((Object)element, (Object)elementName));
        return this;
    }

    @Nullable
    public List<Pair<View, String>> sharedElements() {
        return this.sharedElements;
    }

    @Nullable
    public Pair<View, String> singleSharedElement() {
        return this.sharedElements == null || this.sharedElements.isEmpty() ? null : this.sharedElements.get(0);
    }

    public FragmentRequest sharedElementEnterTransition(@Nullable Object transition) {
        this.specifiedTransitions |= 0x10;
        this.sharedElementEnterTransition = transition;
        return this;
    }

    @Nullable
    public Object sharedElementEnterTransition() {
        return this.sharedElementEnterTransition;
    }

    public FragmentRequest sharedElementReturnTransition(@Nullable Object transition) {
        this.specifiedTransitions |= 0x20;
        this.sharedElementReturnTransition = transition;
        return this;
    }

    @Nullable
    public Object sharedElementReturnTransition() {
        return this.sharedElementReturnTransition;
    }

    boolean hasTransition(int transitionFlag) {
        return (this.specifiedTransitions & transitionFlag) != 0;
    }

    public FragmentRequest replaceSame(boolean replace) {
        return this.setHasFlag(1, replace);
    }

    public boolean replaceSame() {
        return this.hasFlag(1);
    }

    public FragmentRequest addToBackStack(boolean add) {
        return this.setHasFlag(2, add);
    }

    public boolean addToBackStack() {
        return this.hasFlag(2);
    }

    public FragmentRequest allowStateLoss(boolean allow) {
        return this.setHasFlag(4, allow);
    }

    public boolean allowStateLoss() {
        return this.hasFlag(4);
    }

    public FragmentRequest immediate(boolean immediate) {
        return this.setHasFlag(8, immediate);
    }

    public boolean immediate() {
        return this.hasFlag(8);
    }

    private FragmentRequest setHasFlag(int flag, boolean has) {
        this.flags = has ? (this.flags |= flag) : (this.flags &= ~flag);
        return this;
    }

    boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Nullable
    public Fragment execute() {
        this.assertNotExecuted();
        switch (this.transaction) {
            case 0: 
            case 1: {
                if (this.viewContainerId != -1) break;
                throw new IllegalArgumentException("Cannot execute request for REPLACE|ADD transaction. No view container id specified!");
            }
        }
        Fragment fragment = this.controller.executeRequest(this);
        this.executed = true;
        return fragment;
    }

    private void assertNotExecuted() {
        if (this.executed) {
            throw new IllegalStateException("Already executed!");
        }
    }

    public boolean executed() {
        return this.executed;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transaction {
    }
}

