/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.annotation.handler;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import universum.studios.android.fragment.annotation.WebContent;
import universum.studios.android.fragment.annotation.handler.ActionBarAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.AnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.WebFragmentAnnotationHandler;

public final class WebAnnotationHandlers
extends AnnotationHandlers {
    @Nullable
    public static WebFragmentAnnotationHandler obtainWebFragmentHandler(@NonNull Class<?> classOfFragment) {
        return WebAnnotationHandlers.obtainHandler(WebFragmentHandler.class, classOfFragment);
    }

    static final class WebFragmentHandler
    extends ActionBarAnnotationHandlers.ActionBarFragmentHandler
    implements WebFragmentAnnotationHandler {
        private final int webContentResId;
        private final String webContent;

        public WebFragmentHandler(@NonNull Class<?> annotatedClass) {
            super(annotatedClass);
            WebContent webContent = this.findAnnotation(WebContent.class);
            this.webContentResId = webContent == null ? 0 : webContent.valueRes();
            this.webContent = webContent == null ? null : webContent.value();
        }

        @Override
        @StringRes
        public int getWebContentResId(@StringRes int defaultResId) {
            return this.webContentResId == 0 ? defaultResId : this.webContentResId;
        }

        @Override
        @Nullable
        public String getWebContent(@Nullable String defaultContent) {
            return TextUtils.isEmpty((CharSequence)this.webContent) ? defaultContent : this.webContent;
        }
    }
}

