/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.LoaderManager;
import android.content.Loader;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.transition.Transition;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.fragment.ActivityDelegate;
import universum.studios.android.fragment.BackPressWatcher;
import universum.studios.android.fragment.FragmentsConfig;
import universum.studios.android.fragment.ViewClickWatcher;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.BaseAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.FragmentAnnotationHandler;

public abstract class BaseFragment
extends Fragment
implements BackPressWatcher,
ViewClickWatcher {
    private static final String TAG = "BaseFragment";
    private static final int LIFECYCLE_ATTACHED = 1;
    private static final int LIFECYCLE_CREATED = 2;
    private static final int LIFECYCLE_STARTED = 4;
    private static final int LIFECYCLE_RESUMED = 8;
    private static final int LIFECYCLE_PAUSED = 16;
    private static final int LIFECYCLE_STOPPED = 32;
    private static final int LIFECYCLE_DESTROYED = 64;
    private static final int LIFECYCLE_DETACHED = 128;
    final FragmentAnnotationHandler mAnnotationHandler = this.onCreateAnnotationHandler();
    ActivityDelegate mActivityDelegate;
    private int mLifecycleFlags;

    @Nullable
    public static <F extends Fragment> F newInstanceWithArguments(@NonNull Class<F> classOfFragment, @Nullable Bundle args) {
        try {
            Fragment fragment = (Fragment)classOfFragment.newInstance();
            fragment.setArguments(args);
            return (F)fragment;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to instantiate instance of " + classOfFragment + " with arguments!"), (Throwable)e);
            return null;
        }
    }

    FragmentAnnotationHandler onCreateAnnotationHandler() {
        return BaseAnnotationHandlers.obtainFragmentHandler(this.getClass());
    }

    @NonNull
    protected FragmentAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return this.mAnnotationHandler;
    }

    private void updateLifecycleFlags(int flag, boolean add) {
        this.mLifecycleFlags = add ? (this.mLifecycleFlags |= flag) : (this.mLifecycleFlags &= ~flag);
    }

    private boolean hasLifecycleFlag(int flag) {
        return (this.mLifecycleFlags & flag) != 0;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivityDelegate = ActivityDelegate.create(activity);
        this.updateLifecycleFlags(128, false);
        this.updateLifecycleFlags(1, true);
    }

    public final boolean isAttached() {
        return this.hasLifecycleFlag(1);
    }

    @NonNull
    protected Resources.Theme getContextTheme() {
        Activity activity = this.getActivity();
        if (activity == null) {
            throw new IllegalStateException("Fragment is not attached to parent context.");
        }
        return activity.getTheme();
    }

    public final boolean runOnUiThread(@NonNull Runnable action) {
        Activity activity = this.getActivity();
        if (activity != null) {
            activity.runOnUiThread(action);
            return true;
        }
        return false;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.updateLifecycleFlags(64, false);
        this.updateLifecycleFlags(2, true);
    }

    public final boolean isCreated() {
        return this.hasLifecycleFlag(2);
    }

    public void onStart() {
        super.onStart();
        this.updateLifecycleFlags(32, false);
        this.updateLifecycleFlags(4, true);
    }

    public final boolean isStarted() {
        return this.hasLifecycleFlag(4);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int viewResource;
        if (this.mAnnotationHandler != null && (viewResource = this.mAnnotationHandler.getContentViewResource(-1)) != -1) {
            if (this.mAnnotationHandler.shouldAttachContentViewToContainer()) {
                inflater.inflate(viewResource, container, true);
                return null;
            }
            return inflater.inflate(viewResource, container, false);
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        int backgroundResId;
        super.onViewCreated(view, savedInstanceState);
        if (this.mAnnotationHandler != null && (backgroundResId = this.mAnnotationHandler.getContentViewBackgroundResId(-1)) != -1) {
            view.setBackgroundResource(backgroundResId);
        }
    }

    public final boolean isViewCreated() {
        return this.getView() != null;
    }

    public void setAllowEnterTransitionOverlap(boolean allow) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setAllowEnterTransitionOverlap(allow);
        }
    }

    public void setAllowReturnTransitionOverlap(boolean allow) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setAllowReturnTransitionOverlap(allow);
        }
    }

    public void setEnterTransition(Transition transition) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setEnterTransition(transition);
        }
    }

    public void setExitTransition(Transition transition) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setExitTransition(transition);
        }
    }

    public void setReenterTransition(Transition transition) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setReenterTransition(transition);
        }
    }

    public void setReturnTransition(Transition transition) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setReturnTransition(transition);
        }
    }

    public void setSharedElementEnterTransition(Transition transition) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setSharedElementEnterTransition(transition);
        }
    }

    public void setSharedElementReturnTransition(Transition transition) {
        if (FragmentsConfig.TRANSITIONS_SUPPORTED) {
            super.setSharedElementReturnTransition(transition);
        }
    }

    public void onResume() {
        super.onResume();
        this.updateLifecycleFlags(16, false);
        this.updateLifecycleFlags(8, true);
    }

    @Override
    public boolean dispatchViewClick(@NonNull View view) {
        this.onViewClick(view);
        return false;
    }

    protected void onViewClick(@NonNull View view) {
    }

    @Nullable
    public <D> Loader<D> startLoader(@IntRange(from=0L) int id2, @Nullable Bundle params, @NonNull LoaderManager.LoaderCallbacks<D> callbacks) {
        LoaderManager manager = this.getLoaderManager();
        if (manager.getLoader(id2) == null) {
            return this.initLoader(id2, params, callbacks);
        }
        return this.restartLoader(id2, params, callbacks);
    }

    @Nullable
    public <D> Loader<D> initLoader(@IntRange(from=0L) int id2, @Nullable Bundle params, @NonNull LoaderManager.LoaderCallbacks<D> callbacks) {
        return this.getLoaderManager().initLoader(id2, params, callbacks);
    }

    @Nullable
    public <D> Loader<D> restartLoader(@IntRange(from=0L) int id2, @Nullable Bundle params, @NonNull LoaderManager.LoaderCallbacks<D> callbacks) {
        return this.getLoaderManager().restartLoader(id2, params, callbacks);
    }

    public void destroyLoader(@IntRange(from=0L) int id2) {
        this.getLoaderManager().destroyLoader(id2);
    }

    public void onPause() {
        super.onPause();
        this.updateLifecycleFlags(8, false);
        this.updateLifecycleFlags(16, true);
    }

    public final boolean isPaused() {
        return this.hasLifecycleFlag(16);
    }

    public void onStop() {
        super.onStop();
        this.updateLifecycleFlags(4, false);
        this.updateLifecycleFlags(32, true);
    }

    public final boolean isStopped() {
        return this.hasLifecycleFlag(32);
    }

    @Override
    public boolean dispatchBackPress() {
        return this.onBackPress();
    }

    protected boolean onBackPress() {
        return false;
    }

    public void onDestroy() {
        super.onDestroy();
        this.updateLifecycleFlags(2, false);
        this.updateLifecycleFlags(64, true);
    }

    public final boolean isDestroyed() {
        return this.hasLifecycleFlag(64);
    }

    public void onDetach() {
        super.onDetach();
        this.updateLifecycleFlags(1, false);
        this.updateLifecycleFlags(128, true);
        this.mActivityDelegate = null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface LifecycleFlag {
    }
}

