/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.manage;

import android.app.Fragment;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.SparseArray;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.BaseManagementAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.FragmentFactoryAnnotationHandler;
import universum.studios.android.fragment.manage.FragmentFactory;
import universum.studios.android.fragment.manage.FragmentItem;

public abstract class BaseFragmentFactory
implements FragmentFactory {
    private final FragmentFactoryAnnotationHandler mAnnotationHandler = this.onCreateAnnotationHandler();
    private final SparseArray<FragmentItem> mItems = this.mAnnotationHandler != null ? this.mAnnotationHandler.getFragmentItems() : null;
    private int mLastCheckedFragmentId = -1;
    private boolean mFragmentProvided = false;

    @Nullable
    public static String createFragmentTag(@NonNull Class<?> classOfFactory, @NonNull String fragmentName) {
        if (TextUtils.isEmpty((CharSequence)fragmentName)) {
            return null;
        }
        return classOfFactory.getPackage().getName() + "." + classOfFactory.getSimpleName() + ".TAG." + fragmentName;
    }

    private FragmentFactoryAnnotationHandler onCreateAnnotationHandler() {
        return BaseManagementAnnotationHandlers.obtainFactoryHandler(this.getClass());
    }

    @NonNull
    protected FragmentFactoryAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return this.mAnnotationHandler;
    }

    @Override
    public boolean isFragmentProvided(int fragmentId) {
        if (fragmentId == this.mLastCheckedFragmentId) {
            return this.mFragmentProvided;
        }
        this.mLastCheckedFragmentId = fragmentId;
        this.mFragmentProvided = this.providesFragment(fragmentId);
        return this.mFragmentProvided;
    }

    protected boolean providesFragment(int fragmentId) {
        return this.mItems != null && this.mItems.indexOfKey(fragmentId) >= 0;
    }

    @Override
    @Nullable
    public Fragment createFragment(int fragmentId) {
        return this.isFragmentProvided(fragmentId) ? this.onCreateFragment(fragmentId) : null;
    }

    @NonNull
    protected Fragment onCreateFragment(int fragmentId) {
        Fragment fragment = ((FragmentItem)this.mItems.get(fragmentId)).newFragmentInstance(null);
        if (fragment == null) {
            throw new NullPointerException("Failed to instantiate fragment for the requested id(" + fragmentId + ")!");
        }
        return fragment;
    }

    @Override
    @Nullable
    public String createFragmentTag(@IntRange(from=0L) int fragmentId) {
        return this.isFragmentProvided(fragmentId) ? this.onCreateFragmentTag(fragmentId) : null;
    }

    @Nullable
    protected String onCreateFragmentTag(@IntRange(from=0L) int fragmentId) {
        return this.mItems.indexOfKey(fragmentId) >= 0 ? ((FragmentItem)this.mItems.get((int)fragmentId)).tag : BaseFragmentFactory.createFragmentTag(this.getClass(), Integer.toString(fragmentId));
    }
}

