/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.annotation.handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import universum.studios.android.fragment.WebFragment;
import universum.studios.android.fragment.annotation.WebContent;
import universum.studios.android.fragment.annotation.handler.ActionBarAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.AnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.WebFragmentAnnotationHandler;

public final class WebAnnotationHandlers
extends AnnotationHandlers {
    private WebAnnotationHandlers() {
    }

    @Nullable
    public static WebFragmentAnnotationHandler obtainWebFragmentHandler(@NonNull Class<?> classOfFragment) {
        return WebAnnotationHandlers.obtainHandler(WebFragmentHandler.class, classOfFragment);
    }

    static final class WebFragmentHandler
    extends ActionBarAnnotationHandlers.ActionBarFragmentHandler
    implements WebFragmentAnnotationHandler {
        private final int webContentResId;
        private final String webContent;

        public WebFragmentHandler(@NonNull Class<?> annotatedClass) {
            super(annotatedClass, WebFragment.class);
            WebContent webContent = this.findAnnotation(WebContent.class);
            this.webContentResId = webContent != null ? webContent.valueRes() : 0;
            this.webContent = webContent != null ? webContent.value() : null;
        }

        @Override
        @StringRes
        public int getWebContentResId(@StringRes int defaultResId) {
            return this.webContentResId != 0 ? this.webContentResId : defaultResId;
        }

        @Override
        @Nullable
        public String getWebContent(@Nullable String defaultContent) {
            return !TextUtils.isEmpty((CharSequence)this.webContent) ? this.webContent : defaultContent;
        }
    }
}

