/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.app.ActionBar;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import universum.studios.android.fragment.ActionBarDelegate;
import universum.studios.android.fragment.BaseFragment;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.ActionBarAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.ActionBarFragmentAnnotationHandler;

public class ActionBarFragment
extends BaseFragment {
    private ActionMode mActionMode;
    private ActionBarDelegate mActionBarDelegate;

    @Override
    ActionBarFragmentAnnotationHandler onCreateAnnotationHandler() {
        return ActionBarAnnotationHandlers.obtainActionBarFragmentHandler(this.getClass());
    }

    @Override
    @NonNull
    protected ActionBarFragmentAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return (ActionBarFragmentAnnotationHandler)this.mAnnotationHandler;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        ActionBarFragmentAnnotationHandler annotationHandler;
        super.onCreate(savedInstanceState);
        if (this.mAnnotationHandler != null && (annotationHandler = (ActionBarFragmentAnnotationHandler)this.mAnnotationHandler).hasOptionsMenu()) {
            this.setHasOptionsMenu(true);
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        if (this.mAnnotationHandler == null) {
            super.onCreateOptionsMenu(menu, inflater);
            return;
        }
        ActionBarFragmentAnnotationHandler annotationHandler = (ActionBarFragmentAnnotationHandler)this.mAnnotationHandler;
        if (!annotationHandler.hasOptionsMenu()) {
            super.onCreateOptionsMenu(menu, inflater);
            return;
        }
        int menuResource = annotationHandler.getOptionsMenuResource(-1);
        if (menuResource != -1) {
            if (annotationHandler.shouldClearOptionsMenu()) {
                menu.clear();
            }
            if (menuResource == 0) {
                super.onCreateOptionsMenu(menu, inflater);
                return;
            }
            switch (annotationHandler.getOptionsMenuFlags(0)) {
                case 1: {
                    inflater.inflate(menuResource, menu);
                    break;
                }
                case 2: {
                    inflater.inflate(menuResource, menu);
                    super.onCreateOptionsMenu(menu, inflater);
                    break;
                }
                case 0: {
                    super.onCreateOptionsMenu(menu, inflater);
                    inflater.inflate(menuResource, menu);
                }
            }
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mActionBarDelegate = ActionBarDelegate.create(this.getActivity());
        this.invalidateActionBar();
    }

    protected final boolean isActionBarAvailable() {
        return this.mActionBarDelegate != null;
    }

    @NonNull
    protected ActionBarDelegate getActionBarDelegate() {
        if (this.mActionBarDelegate == null) {
            throw new NullPointerException("The parent activity does not have ActionBar presented!");
        }
        return this.mActionBarDelegate;
    }

    @Nullable
    protected ActionBar getActionBar() {
        if (this.mActivityDelegate == null) {
            throw new IllegalStateException("Cannot access ActionBar. " + this.getClass() + " is not attached " + "to the parent activity yet or it has been already detached!");
        }
        return this.mActivityDelegate.getActionBar();
    }

    @Nullable
    protected android.support.v7.app.ActionBar getSupportActionBar() {
        if (this.mActivityDelegate == null) {
            throw new IllegalStateException("Cannot access support ActionBar. " + this.getClass() + " is not attached " + "to the parent activity yet or it has been already detached!");
        }
        return this.mActivityDelegate.getSupportActionBar();
    }

    public void invalidateActionBar() {
        if (this.mActionBarDelegate != null && this.mAnnotationHandler != null) {
            ActionBarFragmentAnnotationHandler annotationHandler = (ActionBarFragmentAnnotationHandler)this.mAnnotationHandler;
            annotationHandler.configureActionBar(this.mActionBarDelegate);
            if (annotationHandler.hasOptionsMenu()) {
                this.setHasOptionsMenu(true);
            }
        }
    }

    protected boolean startActionMode() {
        return this.startActionMode(new ActionModeCallback(this));
    }

    protected boolean startActionMode(@NonNull ActionMode.Callback callback) {
        ActionMode actionMode;
        if (!this.isInActionMode() && this.mActivityDelegate != null && (actionMode = this.mActivityDelegate.startActionMode(callback)) != null) {
            this.onActionModeStarted(actionMode);
            return true;
        }
        return false;
    }

    @CallSuper
    protected void onActionModeStarted(@NonNull ActionMode actionMode) {
        this.mActionMode = actionMode;
    }

    protected boolean isInActionMode() {
        return this.mActionMode != null;
    }

    @Nullable
    protected ActionMode getActionMode() {
        return this.mActionMode;
    }

    protected boolean finishActionMode() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            return true;
        }
        return false;
    }

    @CallSuper
    protected void onActionModeFinished() {
        this.mActionMode = null;
    }

    @Override
    protected boolean onBackPress() {
        return this.finishActionMode() || super.onBackPress();
    }

    public static class ActionModeCallback
    implements ActionMode.Callback {
        protected final ActionBarFragment fragment;

        public ActionModeCallback() {
            this(null);
        }

        public ActionModeCallback(@Nullable ActionBarFragment fragment) {
            this.fragment = fragment;
        }

        public boolean onCreateActionMode(@NonNull ActionMode actionMode, @NonNull Menu menu) {
            if (this.fragment == null || this.fragment.mAnnotationHandler == null) {
                return false;
            }
            ActionBarFragmentAnnotationHandler annotationHandler = (ActionBarFragmentAnnotationHandler)this.fragment.mAnnotationHandler;
            return annotationHandler.handleCreateActionMode(actionMode, menu);
        }

        public boolean onPrepareActionMode(@NonNull ActionMode actionMode, @NonNull Menu menu) {
            return false;
        }

        public boolean onActionItemClicked(@NonNull ActionMode actionMode, @NonNull MenuItem menuItem) {
            if (this.fragment != null && this.fragment.onOptionsItemSelected(menuItem)) {
                actionMode.finish();
                return true;
            }
            return false;
        }

        public void onDestroyActionMode(@NonNull ActionMode actionMode) {
            if (this.fragment != null) {
                this.fragment.onActionModeFinished();
            }
        }
    }
}

