/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.app.AppCompatActivity;
import universum.studios.android.fragment.util.FragmentUtils;

public abstract class ActionBarDelegate {
    protected final Context mContext;

    protected ActionBarDelegate(@NonNull Context context) {
        this.mContext = context;
    }

    @Nullable
    public static ActionBarDelegate create(@NonNull Activity activity) {
        if (activity instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionBar = ((AppCompatActivity)activity).getSupportActionBar();
            return actionBar != null ? ActionBarDelegate.create((Context)activity, actionBar) : null;
        }
        if (Build.VERSION.SDK_INT > 11) {
            ActionBar actionBar = activity.getActionBar();
            return actionBar != null ? ActionBarDelegate.create((Context)activity, actionBar) : null;
        }
        throw new IllegalStateException("Cannot wrap ActionBar of " + activity + " at the current API level(" + Build.VERSION.SDK_INT + ").");
    }

    @NonNull
    public static ActionBarDelegate create(@NonNull Context context, @Nullable ActionBar actionBar) {
        return new Impl(context, actionBar);
    }

    @NonNull
    public static ActionBarDelegate create(@NonNull Context context, @Nullable android.support.v7.app.ActionBar actionBar) {
        return new SupportImpl(context, actionBar);
    }

    public abstract void setDisplayHomeAsUpEnabled(boolean var1);

    public abstract void setHomeAsUpIndicator(@DrawableRes int var1);

    public abstract void setHomeAsUpVectorIndicator(@DrawableRes int var1);

    public abstract void setHomeAsUpIndicator(@Nullable Drawable var1);

    public abstract void setIcon(@DrawableRes int var1);

    public abstract void setIcon(@Nullable Drawable var1);

    public abstract void setTitle(@StringRes int var1);

    public abstract void setTitle(@Nullable CharSequence var1);

    private static final class SupportImpl
    extends ActionBarDelegate {
        private final android.support.v7.app.ActionBar actionBar;

        private SupportImpl(Context context, android.support.v7.app.ActionBar actionBar) {
            super(context);
            this.actionBar = actionBar;
        }

        @Override
        public void setDisplayHomeAsUpEnabled(boolean enabled) {
            if (this.actionBar != null) {
                this.actionBar.setDisplayHomeAsUpEnabled(enabled);
            }
        }

        @Override
        public void setHomeAsUpIndicator(@DrawableRes int resId) {
            if (this.actionBar != null) {
                this.actionBar.setHomeAsUpIndicator(resId);
            }
        }

        @Override
        public void setHomeAsUpVectorIndicator(@DrawableRes int resId) {
            this.setHomeAsUpIndicator(FragmentUtils.getVectorDrawable(this.mContext.getResources(), resId, this.mContext.getTheme()));
        }

        @Override
        public void setHomeAsUpIndicator(@Nullable Drawable indicator) {
            if (this.actionBar != null) {
                this.actionBar.setHomeAsUpIndicator(indicator);
            }
        }

        @Override
        public void setIcon(@DrawableRes int resId) {
            if (this.actionBar != null) {
                this.actionBar.setIcon(resId);
            }
        }

        @Override
        public void setIcon(@Nullable Drawable icon) {
            if (this.actionBar != null) {
                this.actionBar.setIcon(icon);
            }
        }

        @Override
        public void setTitle(@StringRes int resId) {
            if (this.actionBar != null) {
                this.actionBar.setTitle(resId);
            }
        }

        @Override
        public void setTitle(@Nullable CharSequence title) {
            if (this.actionBar != null) {
                this.actionBar.setTitle(title);
            }
        }
    }

    private static final class Impl
    extends ActionBarDelegate {
        private final ActionBar actionBar;

        private Impl(Context context, ActionBar actionBar) {
            super(context);
            this.actionBar = actionBar;
        }

        @Override
        public void setDisplayHomeAsUpEnabled(boolean enabled) {
            if (this.actionBar != null) {
                this.actionBar.setDisplayHomeAsUpEnabled(enabled);
            }
        }

        @Override
        public void setHomeAsUpIndicator(@DrawableRes int resId) {
            if (this.actionBar != null && Build.VERSION.SDK_INT > 18) {
                this.actionBar.setHomeAsUpIndicator(resId);
            }
        }

        @Override
        public void setHomeAsUpVectorIndicator(@DrawableRes int resId) {
            this.setHomeAsUpIndicator(FragmentUtils.getVectorDrawable(this.mContext.getResources(), resId, this.mContext.getTheme()));
        }

        @Override
        public void setHomeAsUpIndicator(@Nullable Drawable indicator) {
            if (this.actionBar != null && Build.VERSION.SDK_INT > 18) {
                this.actionBar.setHomeAsUpIndicator(indicator);
            }
        }

        @Override
        public void setTitle(@StringRes int resId) {
            if (this.actionBar != null) {
                this.actionBar.setTitle(resId);
            }
        }

        @Override
        public void setTitle(@Nullable CharSequence title) {
            if (this.actionBar != null) {
                this.actionBar.setTitle(title);
            }
        }

        @Override
        public void setIcon(@DrawableRes int resId) {
            if (this.actionBar != null) {
                this.actionBar.setIcon(resId);
            }
        }

        @Override
        public void setIcon(@Nullable Drawable icon) {
            if (this.actionBar != null) {
                this.actionBar.setIcon(icon);
            }
        }
    }
}

