/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.form.BaseFormComponent;
import universum.studios.android.form.FormComponent;
import universum.studios.android.form.FormValidator;

public class FormComponentsGroup
extends BaseFormComponent<View, Void> {
    private final SparseArray<FormComponent> components = new SparseArray();
    private FormComponent invalidComponent;
    private int size;

    public FormComponentsGroup(int id) {
        super(id, null);
    }

    public static boolean isGroup(@NonNull FormComponent component) {
        return component instanceof FormComponentsGroup;
    }

    @Override
    public void attachToValidator(@NonNull FormValidator validator) {
        super.attachToValidator(validator);
        for (int i = 0; i < this.size; ++i) {
            ((FormComponent)this.components.get(this.components.keyAt(i))).attachToValidator(validator);
        }
    }

    @Override
    public boolean hasInputChanged() {
        for (int i = 0; i < this.size; ++i) {
            if (!((FormComponent)this.components.get(i)).hasInputChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validate() {
        this.setInvalidComponent(null);
        return this.onValidate(null);
    }

    @Override
    protected boolean onValidate(@Nullable Void input) {
        for (int i = 0; i < this.size; ++i) {
            FormComponent component = (FormComponent)this.components.get(this.components.keyAt(i));
            if (component.validate()) continue;
            this.setInvalidComponent(component);
            return false;
        }
        return true;
    }

    public FormComponentsGroup addComponents(FormComponent ... components) {
        if (components.length > 0) {
            for (FormComponent component : components) {
                this.addComponent(component);
            }
        }
        return this;
    }

    public FormComponentsGroup addComponent(@NonNull FormComponent component) {
        int componentId = component.getId();
        if (this.components.indexOfKey(componentId) < 0) {
            this.components.put(componentId, (Object)component);
            this.size = this.components.size();
        }
        return this;
    }

    @Override
    @Nullable
    public View getView() {
        return null;
    }

    @Override
    @NonNull
    public Void getInput() {
        return null;
    }

    @NonNull
    public SparseArray<FormComponent> getComponents() {
        return this.components;
    }

    @Nullable
    public FormComponent getComponent(int componentId) {
        return this.components.size() > 0 ? (FormComponent)this.components.get(componentId) : null;
    }

    @Nullable
    public FormComponent getInvalidComponent() {
        return this.invalidComponent;
    }

    @Override
    public void setError(@NonNull CharSequence errorMessage) {
    }

    @Override
    public void clearError() {
        super.clearError();
        for (int i = 0; i < this.size; ++i) {
            ((FormComponent)this.components.get(this.components.keyAt(i))).clearError();
        }
    }

    @Override
    @Nullable
    protected FormComponent findComponentTraversal(int id) {
        if (this.id == id) {
            return this;
        }
        for (int i = 0; i < this.size; ++i) {
            FormComponent component = ((FormComponent)this.components.get(this.components.keyAt(i))).findComponent(id);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    private void setInvalidComponent(FormComponent component) {
        this.invalidComponent = component;
    }
}

