/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.content.res.Resources;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import universum.studios.android.form.FormComponent;
import universum.studios.android.form.FormValidator;

public abstract class BaseFormComponent<V extends View, I>
implements FormComponent<V, I> {
    final int id;
    FormValidator validator;
    V view;
    I lastValidatedInput;
    private Resources resources;
    private boolean hasError;

    protected BaseFormComponent(@IntRange(from=0L) int id) {
        this(id, null);
    }

    protected BaseFormComponent(@NonNull V view) {
        this(view.getId(), view);
    }

    protected BaseFormComponent(@IntRange(from=0L) int id, @Nullable V view) {
        this.view = view;
        this.id = id;
    }

    @Override
    public void attachToValidator(@NonNull FormValidator validator) {
        this.validator = validator;
        this.resources = validator.getContext().getResources();
        this.onAttachedToValidator(validator);
    }

    protected void onAttachedToValidator(@NonNull FormValidator validator) {
    }

    @Override
    public boolean hasInputChanged() {
        Object input = this.getInput();
        return this.lastValidatedInput == null || !this.lastValidatedInput.equals(input);
    }

    @Override
    public boolean validate() {
        this.ensureView();
        this.resetCurrentState();
        this.lastValidatedInput = this.getInput();
        return this.onValidate(this.lastValidatedInput);
    }

    private void ensureView() {
        if (this.view == null && this.id > 0) {
            this.attachComponentView(this.id);
        }
    }

    protected void resetCurrentState() {
    }

    @Nullable
    protected final I getLastValidatedInput() {
        return this.lastValidatedInput;
    }

    protected abstract boolean onValidate(@NonNull I var1);

    public final boolean isAttachedToValidator() {
        return this.validator != null;
    }

    @Nullable
    public final FormValidator getValidator() {
        return this.validator;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    @Nullable
    public V getView() {
        this.ensureView();
        return this.view;
    }

    @Override
    public void clearError() {
        this.setHasError(false);
    }

    protected final void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Nullable
    protected final Resources getResources() {
        return this.resources;
    }

    @NonNull
    protected final String obtainString(@StringRes int resId) {
        return this.resources == null ? "" : this.resources.getString(resId);
    }

    @NonNull
    protected final CharSequence obtainText(@StringRes int resId) {
        return this.resources == null ? "" : this.resources.getText(resId);
    }

    @Override
    @Nullable
    public final FormComponent findComponent(int componentId) {
        return componentId > 0 ? this.findComponentTraversal(componentId) : null;
    }

    @Nullable
    protected FormComponent findComponentTraversal(int id) {
        return this.id == id ? this : null;
    }

    private void attachComponentView(int viewId) {
        this.view = this.validator.findViewById(viewId);
        if (this.view == null) {
            throw new IllegalStateException("Failed to attach component view with id(" + viewId + "). View not found in the current root view hierarchy.");
        }
        this.onComponentViewAttached(this.view);
    }

    protected void onComponentViewAttached(@NonNull V view) {
    }
}

