/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.form.FormComponent;

public class FormValidator {
    private static final String TAG = "FormValidator";
    public static final int VALIDATION_MODE_BULK = 1;
    public static final int VALIDATION_MODE_SINGLE = 2;
    private final View.OnClickListener SUBMIT_LISTENER = new View.OnClickListener(){

        public void onClick(@NonNull View view) {
            FormValidator.this.runValidation();
        }
    };
    private final SparseArray<FormComponent> components = new SparseArray();
    protected final Context context;
    protected final View formView;
    private int validationMode = 1;
    private OnFormListener listener;
    private int[] viewIds;

    public FormValidator(@NonNull View formView) {
        this(formView, 1);
    }

    public FormValidator(@NonNull View formView, int mode) {
        this.context = formView.getContext();
        this.formView = formView;
        this.validationMode = mode;
    }

    public FormValidator assignComponents(FormComponent ... components) {
        if (components.length > 0) {
            for (FormComponent component : components) {
                this.assignComponent(component);
            }
        }
        return this;
    }

    public FormValidator assignComponent(@NonNull FormComponent component) {
        int componentId = component.getId();
        if (this.components.indexOfKey(componentId) < 0) {
            component.attachToValidator(this);
            this.components.put(componentId, (Object)component);
        }
        return this;
    }

    public FormValidator assignComponentViews(int ... viewIds) {
        this.viewIds = viewIds;
        return this;
    }

    public boolean runValidation() {
        int n;
        if (this.viewIds != null) {
            this.assignComponentsForViews();
            this.viewIds = null;
        }
        if ((n = this.components.size()) == 0) {
            return false;
        }
        boolean passed = true;
        for (int i = 0; i < n; ++i) {
            FormComponent component = (FormComponent)this.components.get(this.components.keyAt(i));
            if (component.hasInputChanged()) {
                if (component.validate()) {
                    component.clearError();
                    continue;
                }
                this.notifyValidationError(component);
                if (this.validationMode == 2) {
                    this.notifyValidationResult(false);
                    return true;
                }
                passed = false;
                continue;
            }
            if (!component.hasError()) continue;
            passed = false;
        }
        this.notifyValidationResult(passed);
        return true;
    }

    public void clearErrors() {
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            ((FormComponent)this.components.get(this.components.keyAt(i))).clearError();
        }
    }

    private void notifyValidationError(FormComponent component) {
        if (this.listener != null) {
            this.listener.onValidationError(this, component);
        }
    }

    private void notifyValidationResult(boolean passed) {
        if (this.listener != null) {
            this.listener.onValidationResult(this, passed);
        }
    }

    private void assignComponentsForViews() {
        for (int viewId : this.viewIds) {
            View view = this.findViewById(viewId);
            if (view != null && this.onAssignComponentForView(view)) continue;
            Log.e((String)TAG, (String)("Failed to assign form component for view(" + view + ") with id(" + viewId + ")."));
        }
    }

    protected boolean onAssignComponentForView(@NonNull View componentView) {
        return false;
    }

    @Nullable
    public Context getContext() {
        return this.context;
    }

    public void setSubmitView(int id) {
        View submitView = this.formView.findViewById(id);
        if (submitView != null) {
            this.setSubmitView(submitView);
        }
    }

    public void setSubmitView(@NonNull View submitView) {
        submitView.setOnClickListener(this.SUBMIT_LISTENER);
    }

    public void setOnFormListener(@Nullable OnFormListener listener) {
        this.listener = listener;
    }

    public void setValidationMode(int mode) {
        this.validationMode = mode;
    }

    public int getValidationMode() {
        return this.validationMode;
    }

    @NonNull
    public SparseArray<FormComponent> getComponents() {
        return this.components;
    }

    @Nullable
    public FormComponent getComponent(int componentId) {
        return this.components.size() > 0 ? (FormComponent)this.components.get(componentId) : null;
    }

    @Nullable
    public FormComponent findComponent(int componentId) {
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            FormComponent component = ((FormComponent)this.components.get(this.components.keyAt(i))).findComponent(componentId);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    final View findViewById(@IdRes int id) {
        return this.formView.findViewById(id);
    }

    public static interface OnFormListener {
        public void onValidationError(@NonNull FormValidator var1, @NonNull FormComponent var2);

        public void onValidationResult(@NonNull FormValidator var1, boolean var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidationMode {
    }
}

