/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universum.studios.android.form.BaseFormComponent;
import universum.studios.android.form.FormValidator;
import universum.studios.android.ui.widget.EditLayout;

public class FormEditableLayout
extends BaseFormComponent<EditLayout, CharSequence> {
    public static final String NOT_EMPTY_REG_EXP = "^(.+)$";
    private Matcher editMatcher;
    private final int regExpResId;

    public FormEditableLayout(@IdRes int id) {
        this(id, NOT_EMPTY_REG_EXP);
    }

    public FormEditableLayout(@IdRes int id, @NonNull String regExp) {
        super(id, null);
        this.editMatcher = Pattern.compile(regExp).matcher("");
        this.regExpResId = -1;
    }

    public FormEditableLayout(@IdRes int id, @StringRes int regExpResId) {
        super(id, null);
        this.regExpResId = regExpResId;
    }

    public FormEditableLayout(@NonNull EditLayout editable) {
        this(editable, NOT_EMPTY_REG_EXP);
    }

    public FormEditableLayout(@NonNull EditLayout editable, @StringRes int regExpResId) {
        this(editable, editable.getResources().getString(regExpResId));
    }

    public FormEditableLayout(@NonNull EditLayout editable, @NonNull String regExp) {
        super(editable.getId(), editable);
        this.editMatcher = Pattern.compile(regExp).matcher("");
        this.regExpResId = -1;
    }

    @Override
    public boolean hasInputChanged() {
        return this.lastValidatedInput == null || !TextUtils.equals((CharSequence)((CharSequence)this.lastValidatedInput), (CharSequence)this.getInput());
    }

    @Override
    protected boolean onValidate(@NonNull CharSequence input) {
        return this.editMatcher.reset(input).matches();
    }

    @Override
    @NonNull
    public CharSequence getInput() {
        Editable editable = this.getEditableInput();
        return editable == null ? "" : new SpannableStringBuilder((CharSequence)editable);
    }

    @Nullable
    public Editable getEditableInput() {
        return this.view == null ? null : ((EditLayout)this.view).getEditableText();
    }

    @Override
    public void setError(@NonNull CharSequence errorMessage) {
        this.setHasError(true);
        if (this.view != null) {
            ((EditLayout)this.view).setError(errorMessage);
        }
    }

    @Override
    public void clearError() {
        super.clearError();
        if (this.view != null) {
            ((EditLayout)this.view).clearError();
        }
    }

    @Override
    protected void onAttachedToValidator(@NonNull FormValidator validator) {
        super.onAttachedToValidator(validator);
        if (this.regExpResId > 0) {
            this.editMatcher = Pattern.compile(this.obtainString(this.regExpResId)).matcher("");
        }
    }
}

