/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.content.Context;
import android.view.View;
import android.widget.Checkable;
import android.widget.Toast;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import universum.studios.android.form.BaseFormComponent;

public class FormCheckable<V extends View>
extends BaseFormComponent<V, Boolean> {
    private final boolean requiresChecked;

    public FormCheckable(@IdRes int id) {
        this(id, true);
    }

    public FormCheckable(@IdRes int id, boolean requiresChecked) {
        super(id, null);
        this.requiresChecked = requiresChecked;
    }

    public FormCheckable(@NonNull V checkable) {
        this(checkable, true);
    }

    public FormCheckable(@NonNull V checkable, boolean requiresChecked) {
        super(checkable.getId(), checkable);
        this.requiresChecked = requiresChecked;
    }

    @Override
    protected boolean onValidate(@NonNull Boolean input) {
        return this.requiresChecked && input != false;
    }

    public boolean isChecked() {
        return this.getInput();
    }

    @Override
    @NonNull
    public Boolean getInput() {
        return this.view != null && ((Checkable)this.view).isChecked();
    }

    @Override
    public void setError(@NonNull CharSequence errorMessage) {
        Context context;
        if (this.validator != null && (context = this.validator.getContext()) != null) {
            Toast.makeText((Context)context, (CharSequence)errorMessage, (int)0).show();
        }
    }

    @Override
    public void clearError() {
        super.clearError();
    }
}

