/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.EditText;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.form.FormCheckable;
import universum.studios.android.form.FormComponent;
import universum.studios.android.form.FormEditable;
import universum.studios.android.form.FormEditableLayout;
import universum.studios.android.ui.widget.EditLayout;

public class FormValidator {
    private static final String TAG = "FormValidator";
    public static final int VALIDATION_MODE_BULK = 1;
    public static final int VALIDATION_MODE_SINGLE = 2;
    private final View.OnClickListener SUBMIT_LISTENER = new View.OnClickListener(){

        public void onClick(View v) {
            FormValidator.this.runValidation();
        }
    };
    private final SparseArray<FormComponent> COMPONENTS = new SparseArray();
    protected final Context mContext;
    protected final View mFormView;
    private int mValidationMode = 1;
    private OnFormListener mListener;
    private int[] mViewIds;

    public FormValidator(@NonNull View formView) {
        this(formView, 1);
    }

    public FormValidator(@NonNull View formView, int mode) {
        this.mContext = formView.getContext();
        this.mFormView = formView;
        this.mValidationMode = mode;
    }

    public FormValidator assignComponents(FormComponent ... components) {
        if (components.length > 0) {
            for (FormComponent component : components) {
                this.assignComponent(component);
            }
        }
        return this;
    }

    public FormValidator assignComponent(@NonNull FormComponent component) {
        int componentId = component.getId();
        if (this.COMPONENTS.indexOfKey(componentId) < 0) {
            component.attachToValidator(this);
            this.COMPONENTS.put(componentId, (Object)component);
        }
        return this;
    }

    public FormValidator assignComponentViews(int ... viewIds) {
        this.mViewIds = viewIds;
        return this;
    }

    public boolean runValidation() {
        int n;
        if (this.mViewIds != null) {
            this.assignComponentsForViews();
            this.mViewIds = null;
        }
        if ((n = this.COMPONENTS.size()) > 0) {
            boolean passed = true;
            for (int i = 0; i < n; ++i) {
                FormComponent component = (FormComponent)this.COMPONENTS.get(this.COMPONENTS.keyAt(i));
                if (component.hasInputChanged()) {
                    if (!component.validate()) {
                        this.notifyValidationError(component);
                        if (this.mValidationMode == 2) {
                            this.notifyValidationResult(false);
                            return true;
                        }
                        passed = false;
                        continue;
                    }
                    component.clearError();
                    continue;
                }
                if (!component.hasError()) continue;
                passed = false;
            }
            this.notifyValidationResult(passed);
            return true;
        }
        return false;
    }

    public void clearErrors() {
        int n = this.COMPONENTS.size();
        for (int i = 0; i < n; ++i) {
            ((FormComponent)this.COMPONENTS.get(this.COMPONENTS.keyAt(i))).clearError();
        }
    }

    private void notifyValidationError(FormComponent component) {
        if (this.mListener != null) {
            this.mListener.onValidationError(this, component);
        }
    }

    private void notifyValidationResult(boolean passed) {
        if (this.mListener != null) {
            this.mListener.onValidationResult(this, passed);
        }
    }

    private void assignComponentsForViews() {
        for (int viewId : this.mViewIds) {
            View view = this.findViewById(viewId);
            if (view != null && this.onAssignComponentForView(view)) continue;
            Log.e((String)TAG, (String)("Failed to assign form component for view(" + view + ") with id(" + viewId + ")."));
        }
    }

    protected boolean onAssignComponentForView(@NonNull View componentView) {
        if (componentView instanceof EditLayout) {
            this.assignComponent(new FormEditableLayout((EditLayout)componentView));
            return true;
        }
        if (componentView instanceof EditText) {
            this.assignComponent(new FormEditable((EditText)componentView));
            return true;
        }
        if (componentView instanceof CompoundButton) {
            this.assignComponent(new FormCheckable<CompoundButton>((CompoundButton)componentView));
            return true;
        }
        return false;
    }

    @Nullable
    public Context getContext() {
        return this.mContext;
    }

    public void setSubmitView(int id2) {
        View submitView = this.mFormView.findViewById(id2);
        if (submitView != null) {
            this.setSubmitView(submitView);
        }
    }

    public void setSubmitView(@NonNull View submitView) {
        submitView.setOnClickListener(this.SUBMIT_LISTENER);
    }

    public void setOnFormListener(@Nullable OnFormListener listener) {
        this.mListener = listener;
    }

    public void setValidationMode(int mode) {
        this.mValidationMode = mode;
    }

    public int getValidationMode() {
        return this.mValidationMode;
    }

    @NonNull
    public SparseArray<FormComponent> getComponents() {
        return this.COMPONENTS;
    }

    @Nullable
    public FormComponent getComponent(int componentId) {
        return this.COMPONENTS.size() > 0 ? (FormComponent)this.COMPONENTS.get(componentId) : null;
    }

    @Nullable
    public FormComponent findComponent(int componentId) {
        int n = this.COMPONENTS.size();
        for (int i = 0; i < n; ++i) {
            FormComponent component = ((FormComponent)this.COMPONENTS.get(this.COMPONENTS.keyAt(i))).findComponent(componentId);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    final View findViewById(@IdRes int id2) {
        return this.mFormView.findViewById(id2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidationMode {
    }

    public static interface OnFormListener {
        public void onValidationError(@NonNull FormValidator var1, @NonNull FormComponent var2);

        public void onValidationResult(@NonNull FormValidator var1, boolean var2);
    }
}

