/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universum.studios.android.form.BaseFormComponent;
import universum.studios.android.form.FormValidator;
import universum.studios.android.ui.widget.EditLayout;

public class FormEditableLayout
extends BaseFormComponent<EditLayout, CharSequence> {
    private Matcher mEditMatcher;
    private final int mRegExpResId;

    public FormEditableLayout(@IdRes int id2) {
        this(id2, "^(.+)$");
    }

    public FormEditableLayout(@IdRes int id2, @NonNull String regExp) {
        super(id2, null);
        this.mEditMatcher = Pattern.compile(regExp).matcher("");
        this.mRegExpResId = -1;
    }

    public FormEditableLayout(@IdRes int id2, @StringRes int regExpResId) {
        super(id2, null);
        this.mRegExpResId = regExpResId;
    }

    public FormEditableLayout(@NonNull EditLayout editable) {
        this(editable, "^(.+)$");
    }

    public FormEditableLayout(@NonNull EditLayout editable, @StringRes int regExpResId) {
        this(editable, editable.getResources().getString(regExpResId));
    }

    public FormEditableLayout(@NonNull EditLayout editable, @NonNull String regExp) {
        super(editable.getId(), editable);
        this.mEditMatcher = Pattern.compile(regExp).matcher("");
        this.mRegExpResId = -1;
    }

    @Override
    public boolean hasInputChanged() {
        return this.mLastValidatedInput == null || !TextUtils.equals((CharSequence)((CharSequence)this.mLastValidatedInput), (CharSequence)this.getInput());
    }

    @Override
    protected boolean onValidate(@NonNull CharSequence input) {
        return this.mEditMatcher.reset(input).matches();
    }

    @Override
    @NonNull
    public CharSequence getInput() {
        Editable editable = this.getEditableInput();
        return editable != null ? new SpannableStringBuilder((CharSequence)editable) : "";
    }

    @Nullable
    public Editable getEditableInput() {
        return this.mView != null ? ((EditLayout)this.mView).getEditableText() : null;
    }

    @Override
    public void setError(@NonNull CharSequence errorMessage) {
        this.setHasError(true);
        if (this.mView != null) {
            ((EditLayout)this.mView).setError(errorMessage);
        }
    }

    @Override
    public void clearError() {
        super.clearError();
        if (this.mView != null) {
            ((EditLayout)this.mView).clearError();
        }
    }

    @Override
    protected void onAttachedToValidator(@NonNull FormValidator validator) {
        super.onAttachedToValidator(validator);
        if (this.mRegExpResId > 0) {
            this.mEditMatcher = Pattern.compile(this.obtainString(this.mRegExpResId)).matcher("");
        }
    }
}

