/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.widget.EditText;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universum.studios.android.form.BaseFormComponent;
import universum.studios.android.form.FormValidator;

public class FormEditable
extends BaseFormComponent<EditText, CharSequence> {
    public static final String NOT_EMPTY_REG_EXP = "^(.+)$";
    private Matcher mEditMatcher;
    private final int mRegExpResId;

    public FormEditable(@IdRes int id2) {
        this(id2, NOT_EMPTY_REG_EXP);
    }

    public FormEditable(@IdRes int id2, @NonNull String regExp) {
        super(id2, null);
        this.mEditMatcher = Pattern.compile(regExp).matcher("");
        this.mRegExpResId = -1;
    }

    public FormEditable(@IdRes int id2, @StringRes int regExpResId) {
        super(id2, null);
        this.mRegExpResId = regExpResId;
    }

    public FormEditable(@NonNull EditText editable) {
        this(editable, NOT_EMPTY_REG_EXP);
    }

    public FormEditable(@NonNull EditText editable, @StringRes int regExpResId) {
        this(editable, editable.getResources().getString(regExpResId));
    }

    public FormEditable(@NonNull EditText editable, @NonNull String regExp) {
        super(editable.getId(), editable);
        this.mEditMatcher = Pattern.compile(regExp).matcher("");
        this.mRegExpResId = -1;
    }

    @Override
    public boolean hasInputChanged() {
        return this.mLastValidatedInput == null || !TextUtils.equals((CharSequence)((CharSequence)this.mLastValidatedInput), (CharSequence)this.getInput());
    }

    @Override
    protected boolean onValidate(@NonNull CharSequence input) {
        return this.mEditMatcher.reset(input).matches();
    }

    @Override
    @NonNull
    public CharSequence getInput() {
        Editable editable = this.getEditableInput();
        return editable != null ? new SpannableStringBuilder((CharSequence)editable) : "";
    }

    @Nullable
    public Editable getEditableInput() {
        return this.mView != null ? ((EditText)this.mView).getText() : null;
    }

    @Override
    public void setError(@NonNull CharSequence errorMessage) {
        this.setHasError(true);
        if (this.mView != null) {
            ((EditText)this.mView).setError(errorMessage);
        }
    }

    @Override
    public void clearError() {
        super.clearError();
        if (this.mView != null) {
            ((EditText)this.mView).setError(null, null);
        }
    }

    @Override
    protected void onAttachedToValidator(@NonNull FormValidator validator) {
        super.onAttachedToValidator(validator);
        if (this.mRegExpResId > 0) {
            this.mEditMatcher = Pattern.compile(this.obtainString(this.mRegExpResId)).matcher("");
        }
    }
}

