/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.View;
import universum.studios.android.form.BaseFormComponent;
import universum.studios.android.form.FormComponent;
import universum.studios.android.form.FormValidator;

public class FormComponentsGroup
extends BaseFormComponent<View, Void> {
    private final SparseArray<FormComponent> COMPONENTS = new SparseArray();
    private FormComponent mInvalidComponent;
    private int mSize;

    public FormComponentsGroup(int id2) {
        super(id2, null);
    }

    public static boolean isGroup(@NonNull FormComponent component) {
        return component instanceof FormComponentsGroup;
    }

    @Override
    public void attachToValidator(@NonNull FormValidator validator) {
        super.attachToValidator(validator);
        for (int i = 0; i < this.mSize; ++i) {
            ((FormComponent)this.COMPONENTS.get(this.COMPONENTS.keyAt(i))).attachToValidator(validator);
        }
    }

    @Override
    public boolean hasInputChanged() {
        for (int i = 0; i < this.mSize; ++i) {
            if (!((FormComponent)this.COMPONENTS.get(i)).hasInputChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validate() {
        this.setInvalidComponent(null);
        return this.onValidate(null);
    }

    @Override
    protected boolean onValidate(@Nullable Void input) {
        for (int i = 0; i < this.mSize; ++i) {
            FormComponent component = (FormComponent)this.COMPONENTS.get(this.COMPONENTS.keyAt(i));
            if (component.validate()) continue;
            this.setInvalidComponent(component);
            return false;
        }
        return true;
    }

    public void addComponents(FormComponent ... components) {
        if (components.length > 0) {
            for (FormComponent component : components) {
                this.addComponent(component);
            }
        }
    }

    public FormComponentsGroup addComponent(@NonNull FormComponent component) {
        int componentId = component.getId();
        if (this.COMPONENTS.indexOfKey(componentId) < 0) {
            this.COMPONENTS.put(componentId, (Object)component);
            this.mSize = this.COMPONENTS.size();
        }
        return this;
    }

    @Override
    @Nullable
    public View getView() {
        return null;
    }

    @Override
    @NonNull
    public Void getInput() {
        return null;
    }

    @NonNull
    public SparseArray<FormComponent> getComponents() {
        return this.COMPONENTS;
    }

    @Nullable
    public FormComponent getComponent(int componentId) {
        return this.COMPONENTS.size() > 0 ? (FormComponent)this.COMPONENTS.get(componentId) : null;
    }

    @Nullable
    public FormComponent getInvalidComponent() {
        return this.mInvalidComponent;
    }

    @Override
    public void setError(@NonNull CharSequence errorMessage) {
    }

    @Override
    public void clearError() {
        super.clearError();
        for (int i = 0; i < this.mSize; ++i) {
            ((FormComponent)this.COMPONENTS.get(this.COMPONENTS.keyAt(i))).clearError();
        }
    }

    @Override
    @Nullable
    protected FormComponent findComponentTraversal(int id2) {
        if (this.mId == id2) {
            return this;
        }
        for (int i = 0; i < this.mSize; ++i) {
            FormComponent component = ((FormComponent)this.COMPONENTS.get(this.COMPONENTS.keyAt(i))).findComponent(id2);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    private void setInvalidComponent(FormComponent component) {
        this.mInvalidComponent = component;
    }
}

