/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.Checkable;
import android.widget.Toast;
import universum.studios.android.form.BaseFormComponent;

public class FormCheckable<ComponentView extends View>
extends BaseFormComponent<ComponentView, Boolean> {
    private final boolean mRequiresChecked;

    public FormCheckable(@IdRes int id2) {
        this(id2, true);
    }

    public FormCheckable(@IdRes int id2, boolean requiresChecked) {
        super(id2, null);
        this.mRequiresChecked = requiresChecked;
    }

    public FormCheckable(@NonNull ComponentView checkable) {
        this(checkable, true);
    }

    public FormCheckable(@NonNull ComponentView checkable, boolean requiresChecked) {
        super(checkable.getId(), checkable);
        this.mRequiresChecked = requiresChecked;
    }

    @Override
    protected boolean onValidate(@NonNull Boolean input) {
        return this.mRequiresChecked && input != false;
    }

    public boolean isChecked() {
        return this.getInput();
    }

    @Override
    @NonNull
    public Boolean getInput() {
        return this.mView != null && ((Checkable)this.mView).isChecked();
    }

    @Override
    public void setError(@NonNull CharSequence errorMessage) {
        Context context;
        if (this.mValidator != null && (context = this.mValidator.getContext()) != null) {
            Toast.makeText((Context)context, (CharSequence)errorMessage, (int)0).show();
        }
    }

    @Override
    public void clearError() {
        super.clearError();
    }
}

