/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.form;

import android.content.res.Resources;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.view.View;
import universum.studios.android.form.FormComponent;
import universum.studios.android.form.FormValidator;

public abstract class BaseFormComponent<ComponentView extends View, Input>
implements FormComponent<ComponentView, Input> {
    final int mId;
    FormValidator mValidator;
    ComponentView mView;
    Input mLastValidatedInput;
    private Resources mResources;
    private boolean mHasError;

    protected BaseFormComponent(@IntRange(from=0L) int id2) {
        this(id2, null);
    }

    protected BaseFormComponent(@NonNull ComponentView view) {
        this(view.getId(), view);
    }

    protected BaseFormComponent(@IntRange(from=0L) int id2, @Nullable ComponentView view) {
        this.mView = view;
        this.mId = id2;
    }

    @Override
    public void attachToValidator(@NonNull FormValidator validator) {
        this.mValidator = validator;
        this.mResources = validator.getContext().getResources();
        this.onAttachedToValidator(validator);
    }

    protected void onAttachedToValidator(@NonNull FormValidator validator) {
    }

    @Override
    public boolean hasInputChanged() {
        Object input = this.getInput();
        return this.mLastValidatedInput == null || !this.mLastValidatedInput.equals(input);
    }

    @Override
    public boolean validate() {
        this.ensureView();
        this.resetCurrentState();
        this.mLastValidatedInput = this.getInput();
        return this.onValidate(this.mLastValidatedInput);
    }

    private void ensureView() {
        if (this.mView == null && this.mId > 0) {
            this.attachComponentView(this.mId);
        }
    }

    protected void resetCurrentState() {
    }

    @Nullable
    protected final Input getLastValidatedInput() {
        return this.mLastValidatedInput;
    }

    protected abstract boolean onValidate(@NonNull Input var1);

    public final boolean isAttachedToValidator() {
        return this.mValidator != null;
    }

    @Nullable
    public final FormValidator getValidator() {
        return this.mValidator;
    }

    @Override
    public final int getId() {
        return this.mId;
    }

    @Override
    @Nullable
    public ComponentView getView() {
        this.ensureView();
        return this.mView;
    }

    @Override
    public void clearError() {
        this.setHasError(false);
    }

    protected final void setHasError(boolean hasError) {
        this.mHasError = hasError;
    }

    @Override
    public boolean hasError() {
        return this.mHasError;
    }

    @Nullable
    protected final Resources getResources() {
        return this.mResources;
    }

    @NonNull
    protected final String obtainString(@StringRes int resId) {
        return this.mResources != null ? this.mResources.getString(resId) : "";
    }

    @NonNull
    protected final CharSequence obtainText(@StringRes int resId) {
        return this.mResources != null ? this.mResources.getText(resId) : "";
    }

    @Override
    @Nullable
    public final FormComponent findComponent(int componentId) {
        return componentId > 0 ? this.findComponentTraversal(componentId) : null;
    }

    @Nullable
    protected FormComponent findComponentTraversal(int id2) {
        return this.mId == id2 ? this : null;
    }

    private void attachComponentView(int viewId) {
        this.mView = this.mValidator.findViewById(viewId);
        if (this.mView == null) {
            throw new IllegalStateException("Failed to attach component view with id(" + viewId + "). " + "View not found in the current root view hierarchy.");
        }
        this.onComponentViewAttached(this.mView);
    }

    protected void onComponentViewAttached(@NonNull ComponentView view) {
    }
}

