/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.font.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import universum.studios.android.font.Font;
import universum.studios.android.font.FontApplier;
import universum.studios.android.font.FontApplierWidget;
import universum.studios.android.font.FontWidget;

public class FontTextView
extends TextView
implements FontApplierWidget {
    private FontApplier fontApplier = FontApplier.DEFAULT;

    public FontTextView(@NonNull Context context) {
        this(context, null);
    }

    public FontTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public FontTextView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.fontApplier.applyFont(this, attrs, defStyleAttr, 0);
        }
    }

    @TargetApi(value=21)
    public FontTextView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (!this.isInEditMode()) {
            this.fontApplier.applyFont(this, attrs, defStyleAttr, defStyleRes);
        }
    }

    @Override
    public void setFontApplier(@NonNull FontApplier applier) {
        this.fontApplier = applier;
    }

    @Override
    public void setFont(@NonNull String fontPath) {
        this.fontApplier.applyFont((FontWidget)this, fontPath);
    }

    @Override
    public void setFont(@NonNull Font font) {
        this.fontApplier.applyFont((FontWidget)this, font);
    }

    public void setTextAppearance(@NonNull Context context, @StyleRes int resId) {
        super.setTextAppearance(context, resId);
        this.fontApplier.applyFont((FontWidget)this, resId);
    }
}

