/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.font;

import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import universum.studios.android.font.Font;
import universum.studios.android.font.FontWidget;

public interface FontApplier {
    public static final FontApplier DEFAULT = new FontApplier(){

        @Override
        public boolean applyFont(@NonNull FontWidget widget, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
            return this.applyFont(widget, Font.create(widget.getContext(), attrs, defStyleAttr, defStyleRes));
        }

        @Override
        public boolean applyFont(@NonNull FontWidget widget, @StyleRes int style) {
            return this.applyFont(widget, Font.create(widget.getContext(), style));
        }

        @Override
        public boolean applyFont(@NonNull FontWidget widget, @NonNull String fontPath) {
            return this.applyFont(widget, Font.create(fontPath));
        }

        @Override
        public boolean applyFont(@NonNull FontWidget widget, @Nullable Font font) {
            if (font == null) {
                return false;
            }
            widget.setTypeface(font.getTypeface(widget.getContext()));
            return true;
        }
    };

    public boolean applyFont(@NonNull FontWidget var1, @Nullable AttributeSet var2, @AttrRes int var3, @StyleRes int var4);

    public boolean applyFont(@NonNull FontWidget var1, @StyleRes int var2);

    public boolean applyFont(@NonNull FontWidget var1, @NonNull String var2);

    public boolean applyFont(@NonNull FontWidget var1, @Nullable Font var2);
}

