/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.font;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universum.studios.android.font.R;

public final class Font {
    private static final String TAG = "Font";
    public static final String TTF_SUFFIX = ".ttf";
    public static final String FONT_DIR = "font" + File.separator;
    private static final Matcher TTF_SUFFIX_MATCHER = Pattern.compile("(.*)\\.ttf").matcher("");
    private static int logLevel = 7;
    private static String basePath = FONT_DIR;
    private static final Map<String, Font> cache = new HashMap<String, Font>(5);
    private final String filePath;
    private Typeface typeFace;

    public Font(@NonNull String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new IllegalArgumentException("Font path cannot be empty.");
        }
        this.filePath = filePath;
    }

    public static void setLogLevel(int level) {
        logLevel = Math.max(Math.min(7, level), 2);
    }

    private static void logDebugMessage(@NonNull String message) {
        if (logLevel <= 3) {
            Log.d((String)TAG, (String)message);
        }
    }

    public static void setBasePath(@Nullable String basePath) {
        Font.basePath = basePath == null ? FONT_DIR : basePath;
    }

    @Nullable
    public static Font create(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        Resources.Theme theme = context.getTheme();
        TypedArray attributes = theme.obtainStyledAttributes(attrs, new int[]{R.attr.uiFont}, defStyleAttr, defStyleRes);
        String filePath = attributes.getString(0);
        attributes.recycle();
        return TextUtils.isEmpty((CharSequence)filePath) ? null : Font.create(filePath);
    }

    @Nullable
    public static Font create(@NonNull Context context, @StyleRes int style) {
        Resources.Theme theme = context.getTheme();
        TypedArray attributes = theme.obtainStyledAttributes(style, new int[]{R.attr.uiFont});
        String filePath = attributes.getString(0);
        attributes.recycle();
        return TextUtils.isEmpty((CharSequence)filePath) ? null : Font.create(filePath);
    }

    @NonNull
    public static Font create(@NonNull String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new IllegalArgumentException("Font path cannot be empty.");
        }
        String fullFilePath = Font.buildFullPath(filePath);
        if (cache.containsKey(fullFilePath)) {
            Font.logDebugMessage("Re-using cached font for path(" + fullFilePath + ").");
            return cache.get(fullFilePath);
        }
        Font.logDebugMessage("Creating and caching new font for path(" + fullFilePath + ").");
        Font font = new Font(fullFilePath);
        cache.put(fullFilePath, font);
        return font;
    }

    private static String buildFullPath(String filePath) {
        return basePath + (TTF_SUFFIX_MATCHER.reset(filePath).matches() ? filePath : filePath + TTF_SUFFIX);
    }

    public static void clearCache() {
        cache.clear();
    }

    @NonNull
    public String getFilePath() {
        return this.filePath;
    }

    @NonNull
    public Typeface getTypeface(@NonNull Context context) {
        if (this.typeFace == null) {
            try {
                this.typeFace = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)this.filePath);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot create Typeface for font at path(" + this.filePath + "). Font file at the specified path does not exist or it is not a valid .ttf file.", e);
            }
        }
        return this.typeFace;
    }
}

