/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.font.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RadioButton;
import universum.studios.android.font.Font;
import universum.studios.android.font.FontApplier;
import universum.studios.android.font.FontApplierWidget;
import universum.studios.android.font.FontWidget;

public class FontRadioButton
extends RadioButton
implements FontApplierWidget {
    private FontApplier mFontApplier = FontApplier.DEFAULT;

    public FontRadioButton(@NonNull Context context) {
        this(context, null);
    }

    public FontRadioButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16842878);
    }

    public FontRadioButton(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.mFontApplier.applyFont(this, attrs, defStyleAttr, 0);
        }
    }

    @TargetApi(value=21)
    public FontRadioButton(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (!this.isInEditMode()) {
            this.mFontApplier.applyFont(this, attrs, defStyleAttr, defStyleRes);
        }
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)FontRadioButton.class.getName());
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)FontRadioButton.class.getName());
    }

    @Override
    public void setFontApplier(@NonNull FontApplier applier) {
        this.mFontApplier = applier;
    }

    @Override
    public void setFont(@NonNull String fontPath) {
        this.mFontApplier.applyFont((FontWidget)this, fontPath);
    }

    @Override
    public void setFont(@NonNull Font font) {
        this.mFontApplier.applyFont((FontWidget)this, font);
    }

    public void setTextAppearance(@NonNull Context context, @StyleRes int resId) {
        super.setTextAppearance(context, resId);
        this.mFontApplier.applyFont((FontWidget)this, resId);
    }
}

