/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.font;

import android.support.annotation.NonNull;

/**
 * A {@link FontWidget} extended interface that allows to specify a custom {@link FontApplier} that
 * should be used by font widget implementation to perform custom font applying logic.
 *
 * @author Martin Albedinsky
 */
public interface FontApplierWidget extends FontWidget {

	/**
	 * Sets an applier that should be used by this font widget in order to apply custom font requested
	 * via {@link #setFont(Font)}.
	 *
	 * @param applier The desired applier.
	 */
	void setFontApplier(@NonNull FontApplier applier);
}
