/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.font.util;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;

import universum.studios.android.font.Font;
import universum.studios.android.font.FontWidget;

/**
 * <b>This class has been deprecated and will be removed in the next release.</b>
 * <p>
 * Utility class that may be used to simplify setting of custom font to {@link FontWidget} implementations.
 *
 * @author Martin Albedinsky
 * @deprecated Use {@link universum.studios.android.font.FontApplier#DEFAULT} instead.
 */
@Deprecated
public final class FontApplier {

	/*
	 * Interface ===================================================================================
	 */

	/*
	 * Constants ===================================================================================
	 */

	/**
	 * Log TAG.
	 */
	// private static final String TAG = "FontApplier";

	/*
	 * Static members ==============================================================================
	 */

	/*
	 * Members =====================================================================================
	 */

	/*
	 * Constructors ================================================================================
	 */

	/**
	 */
	private FontApplier() {
		// Not allowed to be instantiated publicly.
	}

	/*
	 * Methods =====================================================================================
	 */

	/**
	 * Same as {@link #applyFont(FontWidget, AttributeSet, int, int)} with {@code 0} as attribute for
	 * <var>defStyle</var> and <var>defStyleRes</var>.
	 */
	public static boolean applyFont(@NonNull final FontWidget fontWidget, @Nullable final AttributeSet attrs) {
		return applyFont(fontWidget, attrs, 0, 0);
	}

	/**
	 * Creates font from the specified <var>attrs</var> set and applies it to the given <var>fontWidget</var>.
	 *
	 * @return {@code True} if font was applied, {@code false} otherwise.
	 * @see Font#create(Context, AttributeSet, int, int)
	 */
	public static boolean applyFont(@NonNull final FontWidget fontWidget, @Nullable final AttributeSet attrs, @AttrRes final int defStyleAttr, @StyleRes final int defStyleRes) {
		return applyFont(fontWidget, Font.create(fontWidget.getContext(), attrs, defStyleAttr, defStyleRes));
	}

	/**
	 * Creates font from the specified <var>style</var> and applies it to the given <var>fontWidget</var>.
	 *
	 * @return {@code True} if font was applied, {@code false} otherwise.
	 * @see Font#create(Context, int)
	 */
	public static boolean applyFont(@NonNull final FontWidget fontWidget, @StyleRes final int style) {
		return applyFont(fontWidget, Font.create(fontWidget.getContext(), style));
	}

	/**
	 * Creates font at the specified <var>fontPath</var> and applies it to the given <var>fontWidget</var>.
	 *
	 * @return {@code True} if font was applied, {@code false} otherwise.
	 * @see Font#create(String)
	 */
	public static boolean applyFont(@NonNull final FontWidget fontWidget, @NonNull final String fontPath) {
		return applyFont(fontWidget, Font.create(fontPath));
	}

	/**
	 * Applies the specified <var>font</var> (its Typeface) to the given <var>fontWidget</var>.
	 *
	 * @param font Font of which type face to apply to the widget.
	 * @return {@code True} if font was applied, {@code false} otherwise.
	 */
	public static boolean applyFont(@NonNull final FontWidget fontWidget, @Nullable final Font font) {
		if (font != null) {
			fontWidget.setTypeface(font.getTypeface(fontWidget.getContext()));
			return true;
		}
		return false;
	}

	/*
	 * Inner classes ===============================================================================
	 */
}
