/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.storage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import universum.studios.android.device.storage.Storage;
import universum.studios.android.device.storage.StorageAction;
import universum.studios.android.device.storage.StorageUtils;

final class StorageImpl
implements Storage {
    private static final String TAG = "StorageImpl";
    private static final boolean DEBUG = false;
    private static final String EXTERNAL_PACKAGE_STORAGE_PARENTS_PATH = "Android" + File.separator + "data";
    private static final Object LOCK = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static StorageImpl sInstance;
    private final StorageAction SA_CREATE = new StorageAction.Create(this);
    private final StorageAction SA_DELETE = new StorageAction.Delete(this);
    private final StorageAction SA_COPY = new StorageAction.Copy(this);
    private final StorageAction SA_MOVE = new StorageAction.Move(this);
    private final Context mContext;
    private final String mPackageName;
    private File mExternal;
    private File mExternalPackage;

    private StorageImpl(Context applicationContext) {
        this.mContext = applicationContext;
        this.mPackageName = applicationContext.getPackageName();
        this.checkExternalAvailability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static StorageImpl getInstance(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new StorageImpl(context.getApplicationContext());
            }
        }
        return sInstance;
    }

    @Override
    @NonNull
    public Storage.Result createFile(@NonNull String path) {
        return this.createFile(0, path);
    }

    @Override
    @NonNull
    public Storage.Result createFile(int storage, @NonNull String path) {
        if (StorageUtils.directoryExists(this.appendBasePath(storage, path))) {
            return StorageAction.createResult(1, "Failed to create file. Directory with this name already exists.", path, -1, -18);
        }
        return this.SA_CREATE.performFileAction(storage, -1, "", path);
    }

    @Override
    @NonNull
    public Storage.Results createFiles(String ... paths) {
        return this.createFiles(0, paths);
    }

    @Override
    @NonNull
    public Storage.Results createFiles(int storage, String ... paths) {
        return this.SA_CREATE.performFilesAction(storage, -1, "", paths);
    }

    @Override
    @NonNull
    public Storage.Result createDirectory(@NonNull String path) {
        return this.createDirectory(0, path);
    }

    @Override
    @NonNull
    public Storage.Result createDirectory(int storage, @NonNull String path) {
        if (StorageUtils.directoryExists(this.appendBasePath(storage, path))) {
            return StorageAction.createResult(1, "Failed to create file. Directory with this name already exists.", path, -1, -19);
        }
        return this.SA_CREATE.performDirectoryAction(storage, -1, null, null, "", path);
    }

    @Override
    @NonNull
    public Storage.Results createDirectories(String ... paths) {
        return this.createDirectories(0, paths);
    }

    @Override
    @NonNull
    public Storage.Results createDirectories(int storage, String ... paths) {
        return this.SA_CREATE.performDirectoriesAction(storage, -1, null, null, "", paths);
    }

    @Override
    @NonNull
    public Storage.Result deleteFile(@NonNull String path) {
        return this.deleteFile(0, path);
    }

    @Override
    @NonNull
    public Storage.Result deleteFile(int storage, @NonNull String path) {
        return this.SA_DELETE.performFileAction(storage, -1, "", path);
    }

    @Override
    @NonNull
    public Storage.Results deleteFiles(String ... paths) {
        return this.deleteFiles(0, paths);
    }

    @Override
    @NonNull
    public Storage.Results deleteFiles(int storage, String ... paths) {
        return this.SA_DELETE.performFilesAction(storage, -1, "", paths);
    }

    @Override
    @NonNull
    public Storage.Result deleteDirectory(@NonNull String path) {
        return this.deleteDirectory(0, path);
    }

    @Override
    @NonNull
    public Storage.Result deleteDirectory(int storage, @NonNull String path) {
        return this.deleteDirectory(storage, null, null, path);
    }

    @Override
    @NonNull
    public Storage.Result deleteDirectory(int storage, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @NonNull String path) {
        return this.SA_DELETE.performDirectoryAction(storage, -1, filter, nameFilter, "", path);
    }

    @Override
    @NonNull
    public Storage.Results deleteDirectories(String ... paths) {
        return this.deleteDirectories(0, paths);
    }

    @Override
    @NonNull
    public Storage.Results deleteDirectories(int storage, String ... paths) {
        return this.deleteDirectories(storage, (FileFilter)null, (FilenameFilter)null, paths);
    }

    @Override
    @NonNull
    public Storage.Results deleteDirectories(int storage, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, String ... paths) {
        return this.SA_DELETE.performDirectoriesAction(storage, -1, filter, nameFilter, "", paths);
    }

    @Override
    @NonNull
    public Storage.Result deleteFileOrDirectory(@NonNull String path) {
        return this.deleteFileOrDirectory(0, path);
    }

    @Override
    @NonNull
    public Storage.Result deleteFileOrDirectory(int storage, @NonNull String path) {
        return this.deleteFileOrDirectory(storage, null, null, path);
    }

    @Override
    @NonNull
    public Storage.Result deleteFileOrDirectory(int storage, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @NonNull String path) {
        return this.SA_DELETE.performFileOrDirectoryAction(storage, -1, filter, nameFilter, "", path);
    }

    @Override
    @NonNull
    public Storage.Results deleteFilesOrDirectories(String ... paths) {
        return this.deleteFilesOrDirectories(0, paths);
    }

    @Override
    @NonNull
    public Storage.Results deleteFilesOrDirectories(int storage, String ... paths) {
        return this.deleteFilesOrDirectories(storage, (FileFilter)null, (FilenameFilter)null, paths);
    }

    @Override
    @NonNull
    public Storage.Results deleteFilesOrDirectories(int storage, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, String ... paths) {
        return this.SA_DELETE.performFilesOrDirectoriesAction(storage, -1, filter, nameFilter, "", paths);
    }

    @Override
    @NonNull
    public Storage.Result copyFile(int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.copyFile(0, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result copyFile(int storage, int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.SA_COPY.performFileAction(storage, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Results copyFiles(int flags, @Nullable String toPath, String ... fromPaths) {
        return this.copyFiles(0, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results copyFiles(int storage, int flags, @Nullable String toPath, String ... fromPaths) {
        return this.SA_DELETE.performFilesAction(storage, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Result copyDirectory(int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.copyDirectory(0, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result copyDirectory(int storage, int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.copyDirectory(storage, flags, null, null, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result copyDirectory(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, @NonNull String fromPath) {
        return this.SA_DELETE.performDirectoryAction(storage, flags, filter, nameFilter, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Results copyDirectories(int flags, @Nullable String toPath, String ... fromPaths) {
        return this.copyDirectories(0, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results copyDirectories(int storage, int flags, @Nullable String toPath, String ... fromPaths) {
        return this.copyDirectories(storage, flags, (FileFilter)null, (FilenameFilter)null, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results copyDirectories(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, String ... fromPaths) {
        return this.SA_DELETE.performDirectoriesAction(storage, flags, filter, nameFilter, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Result copyFileOrDirectory(int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.copyFileOrDirectory(0, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result copyFileOrDirectory(int storage, int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.copyFileOrDirectory(storage, flags, null, null, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result copyFileOrDirectory(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, @NonNull String fromPath) {
        return this.SA_COPY.performFileOrDirectoryAction(storage, flags, filter, nameFilter, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Results copyFilesOrDirectories(int flags, @Nullable String toPath, String ... fromPaths) {
        return this.copyFilesOrDirectories(0, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results copyFilesOrDirectories(int storage, int flags, @Nullable String toPath, String ... fromPaths) {
        return this.copyFilesOrDirectories(storage, flags, (FileFilter)null, (FilenameFilter)null, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results copyFilesOrDirectories(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, String ... fromPaths) {
        return this.SA_COPY.performFilesOrDirectoriesAction(storage, flags, filter, nameFilter, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Result moveFile(int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.moveFile(0, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result moveFile(int storage, int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.SA_MOVE.performFileAction(storage, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Results moveFiles(int flags, @Nullable String toPath, String ... fromPaths) {
        return this.moveFiles(0, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results moveFiles(int storage, int flags, @Nullable String toPath, String ... fromPaths) {
        return this.SA_MOVE.performFilesAction(storage, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Result moveDirectory(int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.moveDirectory(0, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result moveDirectory(int storage, int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.moveDirectory(storage, flags, null, null, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result moveDirectory(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, @NonNull String fromPath) {
        return this.SA_MOVE.performDirectoryAction(storage, flags, filter, nameFilter, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Results moveDirectories(int flags, @Nullable String toPath, String ... fromPaths) {
        return this.moveDirectories(0, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results moveDirectories(int storage, int flags, @Nullable String toPath, String ... fromPaths) {
        return this.moveDirectories(storage, flags, (FileFilter)null, (FilenameFilter)null, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results moveDirectories(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, String ... fromPaths) {
        return this.SA_MOVE.performDirectoriesAction(storage, flags, filter, nameFilter, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Result moveFileOrDirectory(int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.moveFileOrDirectory(0, flags, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result moveFileOrDirectory(int storage, int flags, @Nullable String toPath, @NonNull String fromPath) {
        return this.moveFileOrDirectory(storage, flags, null, null, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Result moveFileOrDirectory(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, @NonNull String fromPath) {
        return this.SA_MOVE.performFileOrDirectoryAction(storage, flags, filter, nameFilter, toPath, fromPath);
    }

    @Override
    @NonNull
    public Storage.Results moveFilesOrDirectories(int flags, @Nullable String toPath, String ... fromPaths) {
        return this.moveFilesOrDirectories(0, flags, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results moveFilesOrDirectories(int storage, int flags, @Nullable String toPath, String ... fromPaths) {
        return this.moveFilesOrDirectories(storage, flags, (FileFilter)null, (FilenameFilter)null, toPath, fromPaths);
    }

    @Override
    @NonNull
    public Storage.Results moveFilesOrDirectories(int storage, int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, String ... fromPaths) {
        return this.SA_MOVE.performFilesOrDirectoriesAction(storage, flags, filter, nameFilter, toPath, fromPaths);
    }

    @Override
    public boolean changeFilePermissions(@NonNull String path, int permissions, boolean ownerOnly) {
        return this.changeFilePermissions(0, path, permissions, ownerOnly);
    }

    @Override
    public boolean changeFilePermissions(int storage, @NonNull String path, int permissions, boolean ownerOnly) {
        File file = this.newFile(storage, path);
        if (file.isFile() && permissions > 0) {
            if (file.setExecutable((permissions & 4) != 0, ownerOnly) && file.setWritable((permissions & 2) != 0, ownerOnly) && file.setReadable((permissions & 1) != 0, ownerOnly)) {
                return true;
            }
            Log.e((String)TAG, (String)("Failed to change read/write/execute permissions(" + permissions + ") of file('" + file.getPath() + "')."));
        }
        return false;
    }

    @Override
    public boolean hasFreeSpace(int storage, long bytes) {
        File storageFile = this.getStorage(storage);
        return storageFile != null && storageFile.getFreeSpace() >= bytes;
    }

    @Override
    public long getFreeSpace(int storage) {
        File storageFile = this.getStorage(storage);
        return storageFile == null ? 0L : storageFile.getFreeSpace();
    }

    @Override
    public boolean isExternalReadOnly() {
        return "mounted_ro".equals(Environment.getExternalStorageState());
    }

    @Override
    public boolean isExternalMounted() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    @Override
    public boolean isExternalAvailable() {
        return this.checkExternalAvailability();
    }

    private boolean checkExternalAvailability() {
        boolean available;
        String status;
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state) || "mounted_ro".equals(state)) {
            if (this.mExternal == null) {
                this.mExternal = Environment.getExternalStorageDirectory();
            }
            status = "available";
            available = true;
        } else {
            this.mExternal = null;
            this.mExternalPackage = null;
            status = "not available";
            available = false;
        }
        this.logMessage("External storage is " + status + ".", false);
        return available;
    }

    @Override
    @NonNull
    public String getStoragePath(int storage) {
        if (storage == 0) {
            return "";
        }
        File storageFile = this.getStorage(storage);
        return storageFile == null ? "" : storageFile.getPath();
    }

    @Override
    @Nullable
    public File getStorage(int storage) {
        switch (storage) {
            case 5: {
                return this.mContext.getFilesDir();
            }
            case 6: {
                if (this.checkExternalAvailability()) {
                    return this.mExternal;
                }
                return null;
            }
            case 7: {
                if (this.checkExternalAvailability()) {
                    this.ensureExternalPackageDir();
                    return this.mExternalPackage;
                }
                return null;
            }
            case 1: {
                return Environment.getRootDirectory();
            }
            case 2: {
                return Environment.getDataDirectory();
            }
            case 4: {
                return this.mContext.getCacheDir();
            }
        }
        return null;
    }

    private boolean ensureExternalPackageDir() {
        if (this.mExternal == null) {
            return false;
        }
        if (this.mExternalPackage != null && this.mExternalPackage.isDirectory()) {
            return true;
        }
        if (this.mExternalPackage == null) {
            this.mExternalPackage = new File(this.mExternal.getPath() + File.separator + EXTERNAL_PACKAGE_STORAGE_PARENTS_PATH + File.separator + this.mPackageName);
        }
        if (this.mContext.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", Process.myPid(), Process.myUid()) != 0) {
            return false;
        }
        if (this.mExternalPackage.isDirectory() || this.mExternalPackage.mkdirs()) {
            return true;
        }
        this.logMessage("Failed to create external directory(" + this.mExternalPackage.getPath() + ") for package(" + this.mPackageName + ").", true);
        return false;
    }

    @Override
    @NonNull
    public File getFile(int storage, @NonNull String path) {
        return this.newFile(storage, path);
    }

    @Override
    @NonNull
    public List<File> getDirectoryContent(@NonNull String path) {
        return this.getDirectoryContent(0, path);
    }

    @Override
    @NonNull
    public List<File> getDirectoryContent(int storage, @NonNull String path) {
        return this.getDirectoryContent(storage, null, null, path);
    }

    @Override
    @NonNull
    public List<File> getDirectoryContent(int storage, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @NonNull String path) {
        File dir = this.newFile(storage, path);
        if (dir.isDirectory()) {
            if (filter == null) {
                Object[] files = dir.listFiles(nameFilter);
                return this.isArrayEmpty(files) ? Collections.EMPTY_LIST : Arrays.asList(files);
            }
            Object[] filteredFiles = dir.listFiles(filter);
            if (this.isArrayEmpty(filteredFiles)) {
                return Collections.EMPTY_LIST;
            }
            if (nameFilter != null) {
                ArrayList<File> files = new ArrayList<File>();
                for (Object file : filteredFiles) {
                    if (!nameFilter.accept((File)file, ((File)file).getName())) continue;
                    files.add((File)file);
                }
                return files;
            }
            return Arrays.asList(filteredFiles);
        }
        this.logMessage("Cannot obtain content of directory. Directory(" + dir.getPath() + ") does not exist or it is not a directory.", true);
        return Collections.EMPTY_LIST;
    }

    private File newFile(int storage, String path) {
        return new File(this.buildPath(storage, path));
    }

    private String buildPath(int storage, String path) {
        return this.getStoragePath(storage) + File.separator + path;
    }

    private boolean isArrayEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    @Override
    @NonNull
    public List<File> getDirectoriesContent(String ... paths) {
        return this.getDirectoriesContent(0, paths);
    }

    @Override
    @NonNull
    public List<File> getDirectoriesContent(int storage, String ... paths) {
        return this.getDirectoriesContent(storage, (FileFilter)null, (FilenameFilter)null, paths);
    }

    @Override
    @NonNull
    public List<File> getDirectoriesContent(int storage, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, String ... paths) {
        ArrayList<File> files = new ArrayList<File>();
        if (paths.length > 0) {
            for (String path : paths) {
                files.addAll(this.getDirectoryContent(storage, filter, nameFilter, path));
            }
            return files;
        }
        return files;
    }

    static String getStorageName(int storage) {
        switch (storage) {
            case 5: {
                return "INTERNAL";
            }
            case 6: {
                return "EXTERNAL";
            }
            case 7: {
                return "EXTERNAL_PACKAGE";
            }
            case 1: {
                return "ROOT";
            }
            case 2: {
                return "DATA";
            }
            case 4: {
                return "CACHE";
            }
        }
        return "";
    }

    String appendBasePath(int storage, String path) {
        String basePath = this.getStoragePath(storage);
        return TextUtils.isEmpty((CharSequence)basePath) ? path : basePath + File.separator + path;
    }

    private void logMessage(String message, boolean error) {
        if (error) {
            Log.e((String)TAG, (String)message);
        }
    }
}

