/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.screen;

import android.app.Activity;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;

public final class ScreenUtils {
    private ScreenUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean hideSoftKeyboard(@NonNull Activity activity) {
        View focusedView = activity.getWindow().getCurrentFocus();
        return focusedView != null && ScreenUtils.hideSoftKeyboard(focusedView);
    }

    public static boolean hideSoftKeyboard(@NonNull View focusedView) {
        if (focusedView.getContext() == null || !focusedView.hasFocus()) {
            return false;
        }
        InputMethodManager manager = (InputMethodManager)focusedView.getContext().getSystemService("input_method");
        return manager != null && manager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
    }

    public static boolean showSoftKeyboard(@NonNull Activity activity) {
        View view = activity.getWindow().getCurrentFocus();
        return view != null && ScreenUtils.showSoftKeyboard(view);
    }

    public static boolean showSoftKeyboard(@NonNull View focusedView) {
        if (focusedView.getContext() == null) {
            return false;
        }
        if (focusedView.hasFocus() || focusedView.requestFocus()) {
            InputMethodManager manager = (InputMethodManager)focusedView.getContext().getSystemService("input_method");
            return manager != null && manager.showSoftInput(focusedView, 0);
        }
        return false;
    }
}

