/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.battery;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import universum.studios.android.device.battery.Battery;
import universum.studios.android.device.battery.BatteryHealthReceiver;
import universum.studios.android.device.battery.BatteryPluggedStateReceiver;
import universum.studios.android.device.battery.BatteryStatusReceiver;

final class BatteryImpl
implements Battery {
    private static final String TAG = "BatteryImpl";
    static final boolean DEBUG = false;
    private static final Object LOCK = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static BatteryImpl instance;
    private int healthLowLevel = 15;
    private int healthOkLevel = 20;
    private BatteryStatusReceiver statusReceiver;
    private BatteryHealthReceiver healthReceiver;
    private BatteryPluggedStateReceiver pluggedStateReceiver;
    private final BatteryInfo info = new BatteryInfo();
    private BatteryInfo prevInfo;
    private final List<Battery.OnStatusListener> statusListeners = new ArrayList<Battery.OnStatusListener>(2);
    private final List<Battery.OnHealthListener> healthListeners = new ArrayList<Battery.OnHealthListener>(2);
    private final List<Battery.OnPluggedStateListener> pluggedStateListeners = new ArrayList<Battery.OnPluggedStateListener>(2);
    private final AtomicInteger registeredReceiversCount = new AtomicInteger(0);
    private boolean persistentDataInitialized;
    private boolean dataInitialized;

    private BatteryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static BatteryImpl getInstance(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new BatteryImpl();
            }
        }
        return instance;
    }

    @Override
    public boolean isCharging() {
        this.checkDataInitialization("charging state");
        int status = this.getStatus();
        return status == 2 || status == 5;
    }

    @Override
    public boolean isPlugged() {
        this.checkDataInitialization("plugged state");
        int state = this.getPluggedState();
        return state != -1 && state != 0;
    }

    @Override
    public boolean isLow() {
        return this.getStrength() <= this.getHealthLowLevel();
    }

    @Override
    @IntRange(from=0L, to=100L)
    public int getStrength() {
        this.checkDataInitialization("strength");
        return this.info.strength();
    }

    @Override
    public int getStatus() {
        this.checkDataInitialization("status");
        return this.info.status;
    }

    @Override
    public int getPluggedState() {
        this.checkDataInitialization("plugged state");
        return this.info.pluggedState;
    }

    @Override
    public int getHealth() {
        this.checkDataInitialization("health");
        return this.info.health;
    }

    @Override
    @NonNull
    public Battery.BatteryTechnology getTechnology() {
        this.checkDataInitialization("technology");
        return this.info.technology;
    }

    @Override
    public float getTemperature() {
        this.checkDataInitialization("temperature");
        return (float)this.info.temperature / 10.0f;
    }

    @Override
    public int getVoltage() {
        this.checkDataInitialization("voltage");
        return this.info.voltage;
    }

    private boolean checkDataInitialization(String batteryInfo) {
        if (this.dataInitialized || !this.isBatteryReceiverRegistered(1)) {
            // empty if block
        }
        return this.dataInitialized;
    }

    @Override
    public void setHealthLowLevel(@IntRange(from=0L, to=100L) int level) {
        if (level >= 0 && level <= 100) {
            this.healthLowLevel = level;
        }
    }

    @Override
    @IntRange(from=0L, to=100L)
    public int getHealthLowLevel() {
        return this.healthLowLevel;
    }

    @Override
    public void setHealthOkLevel(int level) {
        if (level >= 0 && level <= 100) {
            this.healthOkLevel = level;
        }
    }

    @Override
    public int getHealthOkLevel() {
        return this.healthOkLevel;
    }

    private void bindBatteryData(Intent intent) {
        int scale;
        this.prevInfo = new BatteryInfo(this.info);
        if (!this.persistentDataInitialized) {
            String technology = intent.getStringExtra("technology");
            this.info.technology = Battery.BatteryTechnology.resolve(technology);
            this.info.voltage = intent.getIntExtra("voltage", this.info.voltage);
            this.persistentDataInitialized = true;
        }
        this.info.status = intent.getIntExtra("status", this.info.status);
        this.info.temperature = intent.getIntExtra("temperature", this.info.temperature);
        int level = intent.getIntExtra("level", -1);
        float strength = (float)level / (float)(scale = intent.getIntExtra("scale", 1));
        if (strength >= 0.0f) {
            this.info.strength = strength;
        }
        this.info.health = intent.getIntExtra("health", this.info.health);
        this.info.pluggedState = intent.getIntExtra("plugged", this.info.pluggedState);
        this.dataInitialized = true;
        this.info.logCurrentData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnStatusListener(@NonNull Battery.OnStatusListener listener) {
        List<Battery.OnStatusListener> list = this.statusListeners;
        synchronized (list) {
            if (!this.statusListeners.contains(listener)) {
                this.statusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnStatusListener(@NonNull Battery.OnStatusListener listener) {
        List<Battery.OnStatusListener> list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnHealthListener(@NonNull Battery.OnHealthListener listener) {
        List<Battery.OnHealthListener> list = this.healthListeners;
        synchronized (list) {
            if (!this.healthListeners.contains(listener)) {
                this.healthListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnHealthListener(@NonNull Battery.OnHealthListener listener) {
        List<Battery.OnHealthListener> list = this.healthListeners;
        synchronized (list) {
            this.healthListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnPluggedStateListener(@NonNull Battery.OnPluggedStateListener listener) {
        List<Battery.OnPluggedStateListener> list = this.pluggedStateListeners;
        synchronized (list) {
            if (!this.pluggedStateListeners.contains(listener)) {
                this.pluggedStateListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnPluggedStateListener(@NonNull Battery.OnPluggedStateListener listener) {
        List<Battery.OnPluggedStateListener> list = this.pluggedStateListeners;
        synchronized (list) {
            this.pluggedStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBatteryReceiver(@NonNull Context context, int receiverFlag) {
        Object object = LOCK;
        synchronized (object) {
            if ((receiverFlag & 1) != 0 && !this.isBatteryReceiverRegistered(1)) {
                this.statusReceiver = new BatteryStatusReceiver();
                context.registerReceiver((BroadcastReceiver)this.statusReceiver, this.statusReceiver.newIntentFilter());
                this.registeredReceiversCount.set(this.registeredReceiversCount.get() | 1);
            }
            if ((receiverFlag & 2) != 0 && !this.isBatteryReceiverRegistered(2)) {
                this.healthReceiver = new BatteryHealthReceiver();
                context.registerReceiver((BroadcastReceiver)this.healthReceiver, this.healthReceiver.newIntentFilter());
                this.registeredReceiversCount.set(this.registeredReceiversCount.get() | 2);
            }
            if ((receiverFlag & 4) != 0 && !this.isBatteryReceiverRegistered(4)) {
                this.pluggedStateReceiver = new BatteryPluggedStateReceiver();
                context.registerReceiver((BroadcastReceiver)this.pluggedStateReceiver, this.pluggedStateReceiver.newIntentFilter());
                this.registeredReceiversCount.set(this.registeredReceiversCount.get() | 4);
            }
        }
    }

    @Override
    public boolean isBatteryReceiverRegistered(int receiverFlag) {
        return (this.registeredReceiversCount.get() & receiverFlag) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterBatteryReceiver(@NonNull Context context, int receiverFlag) {
        Object object = LOCK;
        synchronized (object) {
            if ((receiverFlag & 1) != 0 && this.isBatteryReceiverRegistered(1)) {
                context.unregisterReceiver((BroadcastReceiver)this.statusReceiver);
                this.statusReceiver = null;
                this.registeredReceiversCount.set(this.registeredReceiversCount.get() & 0xFFFFFFFE);
                this.info.resetStatusData();
                this.prevInfo.resetStatusData();
                this.dataInitialized = false;
                this.persistentDataInitialized = false;
                if (!this.isBatteryReceiverRegistered(2)) {
                    this.info.resetHealthState();
                    this.prevInfo.resetHealthState();
                }
                if (!this.isBatteryReceiverRegistered(4)) {
                    this.info.resetPluggedState();
                    this.prevInfo.resetPluggedState();
                }
            }
            if ((receiverFlag & 2) != 0 && this.isBatteryReceiverRegistered(2)) {
                context.unregisterReceiver((BroadcastReceiver)this.healthReceiver);
                this.healthReceiver = null;
                this.registeredReceiversCount.set(this.registeredReceiversCount.get() & 0xFFFFFFFD);
                if (!this.isBatteryReceiverRegistered(1)) {
                    this.info.resetHealthState();
                    this.prevInfo.resetHealthState();
                }
            }
            if ((receiverFlag & 4) != 0 && this.isBatteryReceiverRegistered(4)) {
                context.unregisterReceiver((BroadcastReceiver)this.pluggedStateReceiver);
                this.pluggedStateReceiver = null;
                this.registeredReceiversCount.set(this.registeredReceiversCount.get() & 0xFFFFFFFB);
                if (!this.isBatteryReceiverRegistered(1)) {
                    this.info.resetPluggedState();
                    this.prevInfo.resetPluggedState();
                }
            }
        }
    }

    void handleBroadcast(@NonNull Context context, @NonNull Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        Class receiverClass = (Class)intent.getSerializableExtra(Battery.BatteryBroadcastReceiver.EXTRA_RECEIVER_CLASS);
        if (BatteryStatusReceiver.class.equals((Object)receiverClass)) {
            this.bindBatteryData(intent);
            this.notifyBatteryStatusChange(context);
        } else if (BatteryHealthReceiver.class.equals((Object)receiverClass)) {
            this.notifyBatteryHealthChange(context, action.equals("android.intent.action.BATTERY_LOW"));
        } else if (BatteryPluggedStateReceiver.class.equals((Object)receiverClass)) {
            this.notifyBatteryPluggedStateChange(context, action.equals("android.intent.action.ACTION_POWER_CONNECTED"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatteryStatusChange(Context context) {
        List<Battery.OnStatusListener> list = this.statusListeners;
        synchronized (list) {
            if (!this.statusListeners.isEmpty()) {
                for (Battery.OnStatusListener listener : this.statusListeners) {
                    listener.onStatusChange(context, this);
                }
            }
        }
        if (this.prevInfo != null) {
            if (!this.isBatteryReceiverRegistered(2)) {
                switch (this.prevInfo.getHealthStatus(this.info.strength())) {
                    case 2: {
                        this.notifyBatteryHealthChange(context, true);
                        break;
                    }
                    case 1: {
                        this.notifyBatteryHealthChange(context, false);
                        break;
                    }
                }
            }
            if (!this.isBatteryReceiverRegistered(4) && this.prevInfo.hasPluggedStateChanged(this.info.pluggedState)) {
                this.notifyBatteryPluggedStateChange(context, this.isPlugged());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatteryHealthChange(Context context, boolean low) {
        List<Battery.OnHealthListener> list = this.healthListeners;
        synchronized (list) {
            if (!this.healthListeners.isEmpty()) {
                for (Battery.OnHealthListener listener : this.healthListeners) {
                    if (low) {
                        listener.onHealthLow(context, this);
                        continue;
                    }
                    listener.onHealthOk(context, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatteryPluggedStateChange(Context context, boolean plugged) {
        List<Battery.OnPluggedStateListener> list = this.pluggedStateListeners;
        synchronized (list) {
            if (!this.pluggedStateListeners.isEmpty()) {
                for (Battery.OnPluggedStateListener listener : this.pluggedStateListeners) {
                    if (plugged) {
                        listener.onPluggedToPowerSource(context, this);
                        continue;
                    }
                    listener.onUnpluggedFromPowerSource(context, this);
                }
            }
        }
    }

    private final class BatteryInfo {
        static final int HEALTH_LEVEL_STATUS_UNCHANGED = 0;
        static final int HEALTH_LEVEL_STATUS_OK = 1;
        static final int HEALTH_LEVEL_STATUS_LOW = 2;
        int status = 1;
        int pluggedState = -1;
        Battery.BatteryTechnology technology = Battery.BatteryTechnology.UNKNOWN;
        int health = 1;
        float strength = -0.01f;
        int temperature = -1;
        int voltage = -1;

        BatteryInfo() {
        }

        BatteryInfo(BatteryInfo other) {
            this.health = other.health;
            this.status = other.status;
            this.pluggedState = other.pluggedState;
            this.technology = Battery.BatteryTechnology.resolve(other.technology.tagName);
            this.strength = other.strength;
            this.temperature = other.temperature;
            this.voltage = other.voltage;
        }

        void resetHealthState() {
            this.health = 1;
        }

        void resetPluggedState() {
            this.pluggedState = -1;
        }

        void resetStatusData() {
            this.status = 1;
            this.temperature = -1;
            this.strength = -1;
        }

        boolean hasPluggedStateChanged(int currentStatus) {
            return this.pluggedState != -1 && this.pluggedState != currentStatus;
        }

        int strength() {
            return (int)(((BatteryImpl)BatteryImpl.this).info.strength * 100.0f);
        }

        int getHealthStatus(int currentHealthStrength) {
            int status = 0;
            int prevHealthStrength = this.strength();
            if (prevHealthStrength != currentHealthStrength) {
                if (prevHealthStrength == BatteryImpl.this.healthLowLevel + 1 && currentHealthStrength <= BatteryImpl.this.healthLowLevel) {
                    status = 2;
                } else if (prevHealthStrength == BatteryImpl.this.healthOkLevel && currentHealthStrength > BatteryImpl.this.healthOkLevel) {
                    status = 1;
                }
            }
            return status;
        }

        void logCurrentData() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(64);
            builder.append(BatteryInfo.class.getSimpleName());
            builder.append("{status: ");
            builder.append(this.status);
            builder.append(", health: ");
            builder.append(this.health);
            builder.append(", strength: ");
            builder.append(BatteryImpl.this.getStrength());
            builder.append(", voltage: ");
            builder.append(BatteryImpl.this.getVoltage());
            builder.append(", technology: ");
            builder.append(this.technology.name());
            builder.append(", pluggedState: ");
            builder.append(this.pluggedState);
            builder.append(", temperature: ");
            builder.append(BatteryImpl.this.getTemperature());
            return builder.append("}").toString();
        }
    }
}

