/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import universum.studios.android.device.screen.Screen;

public final class DeviceUtils {
    public static final int UNKNOWN = 0;
    public static final int PHONE = 1;
    public static final int PHABLET = 2;
    public static final int TABLET = 3;
    public static final int TELEVISION = 4;
    public static final int WEARABLE = 5;
    private static final int TABLET_MATCH_SCREEN_DEFAULT_ORIENTATION_POINTS = 60;
    private static final int TABLET_MATCH_SCREEN_TYPE_POINTS = 10;
    private static final int TABLET_MATCH_SCREEN_DENSITY_POINTS = 10;
    private static final int TABLET_MATCH_SCREEN_DIAGONAL_POINTS = 10;
    private static final int MINIMUM_TABLET_PERCENTAGE_MATCH = 85;
    private static final float MINIMUM_TABLET_DIAGONAL_DISTANCE = 6.5f;

    private DeviceUtils() {
        throw new UnsupportedOperationException();
    }

    @SuppressLint(value={"SwitchIntDef"})
    public static boolean isTablet(@NonNull Context context) {
        Screen screen = Screen.PROVIDER.getScreen(context);
        int percentageMatch = 0;
        switch (screen.getDefaultOrientation()) {
            case 0: {
                percentageMatch += 60;
                break;
            }
        }
        switch (screen.getType()) {
            case LARGE: 
            case XLARGE: {
                percentageMatch += 10;
                break;
            }
        }
        if (screen.getDiagonalDistanceInInches() >= 6.5f) {
            percentageMatch += 10;
        }
        switch (screen.getDensity()) {
            case MDPI: 
            case HDPI: 
            case XHDPI: {
                percentageMatch += 10;
                break;
            }
        }
        return percentageMatch >= 85;
    }
}

