/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.storage;

import android.text.TextUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.device.storage.Storage;
import universum.studios.android.device.storage.StorageImpl;
import universum.studios.android.device.storage.StorageUtils;

abstract class StorageAction {
    private final StorageImpl storage;
    private final int action;
    private final String actionVerb;
    private final String actionVerbPast;

    private StorageAction(StorageImpl storage, int action, String actionVerb, String actionVerbPast) {
        this.storage = storage;
        this.action = action;
        this.actionVerb = actionVerb;
        this.actionVerbPast = actionVerbPast;
    }

    Storage.Result performFileAction(int storage, int flags, String toPath, String fromPath) {
        int errorCode = -3;
        String exMessage = "";
        boolean success = false;
        try {
            success = this.onPerformFileAction(flags, this.storage.appendBasePath(storage, toPath), this.storage.appendBasePath(storage, fromPath));
        }
        catch (FileNotFoundException e) {
            errorCode = -17;
            exMessage = e.getMessage();
        }
        catch (IOException e) {
            errorCode = -1;
            exMessage = e.getMessage();
        }
        catch (IllegalArgumentException e) {
            errorCode = -18;
            exMessage = e.getMessage();
        }
        return StorageAction.createResult(this.action, success ? StorageAction.buildStorageMessage("Successfully " + this.actionVerbPast + " file('" + fromPath + "')", storage, null) : StorageAction.buildStorageMessage("Failed to " + this.actionVerb + " file('" + fromPath + "')", storage, exMessage), fromPath, flags, success ? 0 : errorCode);
    }

    abstract boolean onPerformFileAction(int var1, String var2, String var3) throws IOException;

    Storage.Results performFilesAction(int storage, int flags, String toPath, String ... fromPaths) {
        if (fromPaths.length > 0) {
            ArrayList<Storage.Result> results = new ArrayList<Storage.Result>();
            int passed = 0;
            for (String fromPath : fromPaths) {
                Storage.Result result = this.performFileAction(storage, flags, toPath, fromPath);
                if (!result.isError) {
                    ++passed;
                }
                results.add(result);
            }
            return this.processResults(results, passed, "files", storage, -3);
        }
        return StorageAction.createResults(this.action, 0, "No files to " + this.actionVerb + ".", null, -1, 0);
    }

    Storage.Result performDirectoryAction(int storage, int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String fromPath) {
        int errorCode = -3;
        String exMessage = "";
        boolean success = false;
        try {
            success = this.onPerformDirectoryAction(flags, filter, nameFilter, this.storage.appendBasePath(storage, toPath), this.storage.appendBasePath(storage, fromPath));
        }
        catch (FileNotFoundException e) {
            errorCode = -17;
            exMessage = e.getMessage();
        }
        catch (IOException e) {
            errorCode = -1;
            exMessage = e.getMessage();
        }
        catch (IllegalArgumentException e) {
            errorCode = -18;
            exMessage = e.getMessage();
        }
        catch (UnsupportedOperationException e) {
            errorCode = -2;
            exMessage = e.getMessage();
        }
        return StorageAction.createResult(this.action, success ? StorageAction.buildStorageMessage("Successfully " + this.actionVerbPast + " directory('" + fromPath + "')", storage, null) : StorageAction.buildStorageMessage("Failed to " + this.actionVerb + " directory('" + fromPath + "')", storage, exMessage), fromPath, flags, success ? 0 : errorCode);
    }

    abstract boolean onPerformDirectoryAction(int var1, FileFilter var2, FilenameFilter var3, String var4, String var5) throws IOException;

    Storage.Results performDirectoriesAction(int storage, int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String ... fromPaths) {
        if (fromPaths.length > 0) {
            ArrayList<Storage.Result> results = new ArrayList<Storage.Result>();
            int passed = 0;
            for (String fromPath : fromPaths) {
                Storage.Result result = this.performDirectoryAction(storage, flags, filter, nameFilter, toPath, fromPath);
                if (!result.isError) {
                    ++passed;
                }
                results.add(result);
            }
            return this.processResults(results, passed, "directories", storage, -3);
        }
        return StorageAction.createResults(this.action, 0, "No directories to " + this.actionVerb + ".", null, flags, 0);
    }

    Storage.Results performFilesOrDirectoriesAction(int storage, int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String ... fromPaths) {
        if (fromPaths.length > 0) {
            ArrayList<Storage.Result> results = new ArrayList<Storage.Result>();
            int passed = 0;
            for (String fromPath : fromPaths) {
                Storage.Result result = this.performFileOrDirectoryAction(storage, flags, filter, nameFilter, toPath, fromPath);
                if (!result.isError) {
                    ++passed;
                }
                results.add(result);
            }
            return this.processResults(results, passed, "files/directories", storage, -3);
        }
        return StorageAction.createResults(this.action, 0, "No files/directories to delete.", null, flags, 0);
    }

    Storage.Result performFileOrDirectoryAction(int storage, int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String fromPath) {
        File file = new File(this.storage.appendBasePath(storage, fromPath));
        if (file.exists()) {
            return file.isFile() ? this.performFileAction(storage, flags, toPath, fromPath) : this.performDirectoryAction(storage, flags, filter, nameFilter, toPath, fromPath);
        }
        return StorageAction.createResult(this.action, "No file/directory to " + this.actionVerb + ".", fromPath, flags, 0);
    }

    private static String buildStorageMessage(String baseMessage, int storage, String exceptionMessage) {
        String storageName = StorageImpl.getStorageName(storage);
        String message = TextUtils.isEmpty((CharSequence)storageName) ? baseMessage + " at device storage." : baseMessage + " on" + storageName + " storage.";
        return TextUtils.isEmpty((CharSequence)exceptionMessage) ? message : message + "\n" + exceptionMessage;
    }

    private Storage.Results processResults(List<Storage.Result> results, int passed, String fileType, int storage, int errorCode) {
        int size = results.size();
        if (passed != results.size()) {
            return StorageAction.createResults(this.action, passed, StorageAction.buildStorageMessage("Failed to " + this.actionVerb + " " + Integer.toString(size - passed) + " " + fileType, storage, null), results, -1, errorCode);
        }
        return StorageAction.createResults(this.action, size, StorageAction.buildStorageMessage("Successfully " + this.actionVerbPast + " " + Integer.toString(passed) + " " + fileType, storage, null), results, -1, 0);
    }

    static Storage.Result createResult(int action, String message, String path, int flags, int error) {
        return new Storage.Result(action, message, path, flags, error);
    }

    private static Storage.Results createResults(int action, int size, String message, List<Storage.Result> results, int flags, int error) {
        return new Storage.Results(action, message, size, results, flags, error);
    }

    static final class Move
    extends StorageAction {
        Move(StorageImpl storage) {
            super(storage, 4, "move", "moved");
        }

        @Override
        boolean onPerformFileAction(int flags, String toPath, String fromPath) throws IOException {
            return StorageUtils.moveFile(flags, toPath, fromPath);
        }

        @Override
        boolean onPerformDirectoryAction(int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String fromPath) throws IOException {
            return StorageUtils.moveDirectory(flags, filter, nameFilter, toPath, fromPath);
        }
    }

    static final class Copy
    extends StorageAction {
        Copy(StorageImpl storage) {
            super(storage, 3, "copy", "copied");
        }

        @Override
        boolean onPerformFileAction(int flags, String toPath, String fromPath) throws IOException {
            return StorageUtils.copyFile(flags, toPath, fromPath);
        }

        @Override
        boolean onPerformDirectoryAction(int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String fromPath) throws IOException {
            return StorageUtils.copyDirectory(flags, filter, nameFilter, toPath, fromPath);
        }
    }

    static final class Delete
    extends StorageAction {
        Delete(StorageImpl storage) {
            super(storage, 2, "delete", "deleted");
        }

        @Override
        boolean onPerformFileAction(int flags, String toPath, String fromPath) throws IOException {
            return StorageUtils.deleteFile(fromPath);
        }

        @Override
        boolean onPerformDirectoryAction(int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String fromPath) throws IOException {
            return StorageUtils.deleteDirectory(filter, nameFilter, fromPath);
        }
    }

    static final class Create
    extends StorageAction {
        Create(StorageImpl storage) {
            super(storage, 1, "create", "created");
        }

        @Override
        boolean onPerformFileAction(int flags, String toPath, String fromPath) throws IOException {
            return StorageUtils.createFile(fromPath);
        }

        @Override
        boolean onPerformDirectoryAction(int flags, FileFilter filter, FilenameFilter nameFilter, String toPath, String fromPath) throws IOException {
            return StorageUtils.createDirectory(fromPath);
        }
    }
}

