/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.screen;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import universum.studios.android.device.screen.Screen;

final class ScreenImpl
implements Screen {
    private static final Object LOCK = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static ScreenImpl instance;
    private final DisplayMetrics metrics = new DisplayMetrics();
    private final Context context;
    private final int width;
    private final int height;
    private final WindowManager windowManager;
    private final int defaultOrientation;
    private final Screen.ScreenType type;
    private final Screen.ScreenDensity density;
    private final int rawDensity;
    private int currentOrientation = -1;
    private Screen.ScreenRotation currentRotation = Screen.ScreenRotation.UNKNOWN;
    private int currentWidth;
    private int currentHeight;
    private boolean orientationLocked;

    private ScreenImpl(Context applicationContext) {
        boolean reverse;
        float defaultHeightDP;
        float defaultWidthDP;
        this.context = applicationContext;
        this.windowManager = (WindowManager)applicationContext.getSystemService("window");
        this.refresh();
        block0 : switch (this.currentRotation) {
            case ROTATION_0: 
            case ROTATION_180: {
                switch (this.currentOrientation) {
                    case 0: 
                    case 8: {
                        this.defaultOrientation = 0;
                        break block0;
                    }
                    case 1: 
                    case 9: {
                        this.defaultOrientation = 1;
                        break block0;
                    }
                }
                this.defaultOrientation = -1;
                break;
            }
            case ROTATION_90: 
            case ROTATION_270: {
                switch (this.currentOrientation) {
                    case 0: 
                    case 8: {
                        this.defaultOrientation = 1;
                        break block0;
                    }
                    case 1: 
                    case 9: {
                        this.defaultOrientation = 0;
                        break block0;
                    }
                }
                this.defaultOrientation = -1;
                break;
            }
            default: {
                this.defaultOrientation = -1;
            }
        }
        this.rawDensity = this.metrics.densityDpi;
        this.density = Screen.ScreenDensity.resolve(this.rawDensity);
        switch (this.currentOrientation) {
            case 0: 
            case 8: {
                defaultWidthDP = this.pixelToDP(this.metrics.heightPixels);
                defaultHeightDP = this.pixelToDP(this.metrics.widthPixels);
                break;
            }
            case 1: 
            case 9: {
                defaultWidthDP = this.pixelToDP(this.metrics.widthPixels);
                defaultHeightDP = this.pixelToDP(this.metrics.heightPixels);
                break;
            }
            default: {
                defaultWidthDP = this.pixelToDP(this.metrics.widthPixels);
                defaultHeightDP = this.pixelToDP(this.metrics.heightPixels);
            }
        }
        this.type = Screen.ScreenType.resolve(defaultWidthDP, defaultHeightDP);
        switch (this.defaultOrientation) {
            case 1: {
                reverse = this.currentOrientation != 1 && this.currentOrientation != 9;
                break;
            }
            case 0: {
                reverse = this.currentOrientation != 0 && this.currentOrientation != 8;
                break;
            }
            default: {
                reverse = false;
            }
        }
        this.currentWidth = this.metrics.widthPixels;
        this.currentHeight = this.metrics.heightPixels;
        this.width = reverse ? this.currentHeight : this.currentWidth;
        this.height = reverse ? this.currentWidth : this.currentHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static ScreenImpl getsInstance(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new ScreenImpl(context.getApplicationContext());
            }
        }
        return instance;
    }

    @Override
    public boolean isOn() {
        PowerManager power = (PowerManager)this.context.getSystemService("power");
        return power != null && power.isScreenOn();
    }

    @Override
    @TargetApi(value=20)
    public boolean isInteractive() {
        PowerManager power = (PowerManager)this.context.getSystemService("power");
        return power != null && power.isInteractive();
    }

    @Override
    public boolean lockOrientation(@NonNull Activity activity) {
        return this.requestOrientation(activity, -2);
    }

    @Override
    public void unlockOrientation(@NonNull Activity activity) {
        this.requestOrientation(activity, 2);
    }

    @Override
    public boolean requestOrientation(@NonNull Activity activity, int orientation) {
        switch (orientation) {
            case -2: {
                activity.setRequestedOrientation(this.getCurrentOrientation());
                break;
            }
            case -1: {
                break;
            }
            default: {
                activity.setRequestedOrientation(orientation);
            }
        }
        this.orientationLocked = orientation != 2;
        return this.orientationLocked;
    }

    @Override
    public int getRequestedOrientation(@NonNull Activity activity) {
        return activity.getRequestedOrientation();
    }

    @Override
    @NonNull
    public Display getDisplay() {
        return this.windowManager.getDefaultDisplay();
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getWidth() {
        return this.width;
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getHeight() {
        return this.height;
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getCurrentWidth() {
        this.refresh();
        return this.currentWidth;
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getCurrentHeight() {
        this.refresh();
        return this.currentHeight;
    }

    @Override
    @NonNull
    public DisplayMetrics getMetrics() {
        this.refresh();
        return this.metrics;
    }

    @Override
    @NonNull
    public Screen.ScreenDensity getDensity() {
        return this.density;
    }

    @Override
    public int getRawDensity() {
        return this.rawDensity;
    }

    @Override
    @NonNull
    public Screen.ScreenType getType() {
        return this.type;
    }

    @Override
    public int getCurrentOrientation() {
        this.refresh();
        return this.currentOrientation;
    }

    @Override
    public int getDefaultOrientation() {
        return this.defaultOrientation;
    }

    @Override
    @NonNull
    public Screen.ScreenRotation getCurrentRotation() {
        this.refresh();
        return this.currentRotation;
    }

    @Override
    @FloatRange(from=0.0)
    public float getDiagonalDistanceInInches() {
        this.refresh();
        return (float)Math.sqrt(Math.pow((float)this.width / this.metrics.xdpi, 2.0) + Math.pow((float)this.height / this.metrics.ydpi, 2.0));
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getDiagonalDistanceInPixels() {
        this.refresh();
        return Math.round((float)Math.sqrt(Math.pow(this.width, 2.0) + Math.pow(this.height, 2.0)));
    }

    @Override
    public float getRefreshRate() {
        return this.getDisplay().getRefreshRate();
    }

    @Override
    public int getBrightness(@NonNull Activity activity) {
        Window window = activity.getWindow();
        return Math.round(window.getAttributes().screenBrightness * 100.0f);
    }

    @Override
    public void setBrightness(@NonNull Activity activity, @IntRange(from=0L, to=100L) int brightness) {
        if (brightness < 0 || brightness > 100) {
            throw new IllegalArgumentException("Brightness value(" + brightness + ") is out of the range [0, 100].");
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.screenBrightness = (float)Math.max(1, brightness) / 100.0f;
        window.setAttributes(layoutParams);
    }

    @Override
    public int getSystemBrightness() {
        float brightness = 0.0f;
        try {
            brightness = Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return Math.round(brightness / 255.0f * 100.0f);
    }

    @Override
    public boolean isOrientationLocked() {
        return this.orientationLocked;
    }

    @Override
    public float pixelToDP(@Px int pixel) {
        return (float)pixel / (this.density.value / 160.0f);
    }

    @Override
    @Px
    public int dpToPixel(float dp) {
        return Math.round(dp * (this.density.value / 160.0f));
    }

    @Override
    public float getScreenDP() {
        return this.density.value / 160.0f;
    }

    private void refresh() {
        this.getDisplay().getMetrics(this.metrics);
        if (this.currentWidth != this.metrics.widthPixels || this.currentHeight != this.metrics.heightPixels) {
            this.onRefresh();
        }
    }

    private void onRefresh() {
        int orientation = -1;
        this.currentRotation = Screen.ScreenRotation.resolve(this.getDisplay().getRotation());
        block0 : switch (this.context.getResources().getConfiguration().orientation) {
            case 2: {
                switch (this.currentRotation) {
                    case ROTATION_0: 
                    case ROTATION_90: {
                        orientation = 0;
                        break block0;
                    }
                    case ROTATION_180: 
                    case ROTATION_270: {
                        orientation = 8;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.currentRotation) {
                    case ROTATION_0: 
                    case ROTATION_270: {
                        orientation = 1;
                        break block0;
                    }
                    case ROTATION_180: 
                    case ROTATION_90: {
                        orientation = 9;
                        break block0;
                    }
                }
                break;
            }
        }
        this.currentOrientation = orientation;
        this.currentWidth = this.metrics.widthPixels;
        this.currentHeight = this.metrics.heightPixels;
    }
}

