/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.screen;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.device.screen.ScreenImpl;

public interface Screen {
    public static final Provider PROVIDER = new Provider(){

        @Override
        @NonNull
        public Screen getScreen(@NonNull Context context) {
            return ScreenImpl.getsInstance(context);
        }
    };
    public static final int ORIENTATION_CURRENT = -2;
    public static final int ORIENTATION_UNSPECIFIED = -1;
    public static final int ORIENTATION_LANDSCAPE = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_USER = 2;
    public static final int ORIENTATION_BEHIND = 3;
    public static final int ORIENTATION_SENSOR = 4;
    public static final int ORIENTATION_SENSOR_LANDSCAPE = 6;
    public static final int ORIENTATION_SENSOR_PORTRAIT = 7;
    public static final int ORIENTATION_REVERSE_LANDSCAPE = 8;
    public static final int ORIENTATION_REVERSE_PORTRAIT = 9;
    public static final int ORIENTATION_FULL_SENSOR = 10;

    public boolean isOn();

    public boolean isInteractive();

    @NonNull
    public Display getDisplay();

    @Px
    @IntRange(from=0L)
    public int getWidth();

    @Px
    @IntRange(from=0L)
    public int getHeight();

    @Px
    @IntRange(from=0L)
    public int getCurrentWidth();

    @Px
    @IntRange(from=0L)
    public int getCurrentHeight();

    @NonNull
    public DisplayMetrics getMetrics();

    @NonNull
    public ScreenDensity getDensity();

    public int getRawDensity();

    @NonNull
    public ScreenType getType();

    public int getDefaultOrientation();

    public int getCurrentOrientation();

    @NonNull
    public ScreenRotation getCurrentRotation();

    @FloatRange(from=0.0)
    public float getDiagonalDistanceInInches();

    @Px
    @IntRange(from=0L)
    public int getDiagonalDistanceInPixels();

    @IntRange(from=-1L, to=100L)
    public int getBrightness(@NonNull Activity var1);

    public void setBrightness(@NonNull Activity var1, @IntRange(from=0L, to=100L) int var2);

    @IntRange(from=0L, to=100L)
    public int getSystemBrightness();

    public boolean requestOrientation(@NonNull Activity var1, int var2);

    public int getRequestedOrientation(@NonNull Activity var1);

    public boolean lockOrientation(@NonNull Activity var1);

    public void unlockOrientation(@NonNull Activity var1);

    public boolean isOrientationLocked();

    public float pixelToDP(@Px int var1);

    @Px
    public int dpToPixel(float var1);

    public float getScreenDP();

    public float getRefreshRate();

    public static enum ScreenRotation {
        UNKNOWN(-1, -1),
        ROTATION_0(0, 0),
        ROTATION_90(90, 1),
        ROTATION_180(180, 2),
        ROTATION_270(270, 3);

        public final int degrees;
        public final int systemConstant;

        private ScreenRotation(int degreesValue, int flag) {
            this.degrees = degreesValue;
            this.systemConstant = flag;
        }

        @NonNull
        public static ScreenRotation resolve(int systemConstant) {
            for (ScreenRotation rotation : ScreenRotation.values()) {
                if (rotation.systemConstant != systemConstant) continue;
                return rotation;
            }
            return UNKNOWN;
        }
    }

    public static enum ScreenType {
        UNKNOWN(-1.0f, -1.0f),
        SMALL(320.0f, 426.0f),
        NORMAL(320.0f, 470.0f),
        LARGE(480.0f, 640.0f),
        XLARGE(720.0f, 960.0f);

        private static final ScreenType[] REVERSED_VALUES;
        public final float nativeWidthDp;
        public final float nativeHeightDp;

        private ScreenType(float nativeWidthDp, float nativeHeightDp) {
            this.nativeWidthDp = nativeWidthDp;
            this.nativeHeightDp = nativeHeightDp;
        }

        @NonNull
        public static ScreenType resolve(float widthDp, float heightDp) {
            for (ScreenType type : REVERSED_VALUES) {
                if (!(widthDp >= type.nativeWidthDp) || !(heightDp >= type.nativeHeightDp)) continue;
                return type;
            }
            return UNKNOWN;
        }

        static {
            REVERSED_VALUES = new ScreenType[]{XLARGE, LARGE, NORMAL, SMALL, UNKNOWN};
        }
    }

    public static enum ScreenDensity {
        UNKNOWN(0.0f, 0.0f),
        LDPI(120.0f, 0.75f),
        MDPI(160.0f, 1.0f),
        HDPI(240.0f, 1.5f),
        XHDPI(320.0f, 2.0f),
        XXHDPI(480.0f, 3.0f),
        XXXHDPI(640.0f, 4.0f);

        public final float value;
        public final float scaleRatio;
        private static final float DENSITY_CHECK_OFFSET = 10.0f;

        private ScreenDensity(float value, float scaleRatio) {
            this.value = value;
            this.scaleRatio = scaleRatio;
        }

        @NonNull
        public static ScreenDensity resolve(float densityDpi) {
            for (ScreenDensity density : ScreenDensity.values()) {
                if (!(densityDpi + 10.0f >= density.value) || !(densityDpi - 10.0f <= density.value)) continue;
                return density;
            }
            return UNKNOWN;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }

    public static interface Provider {
        @NonNull
        public Screen getScreen(@NonNull Context var1);
    }
}

