/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.connection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import universum.studios.android.device.connection.Connection;
import universum.studios.android.device.connection.ConnectionStateReceiver;

final class ConnectionImpl
implements Connection {
    private static final Object LOCK = new Object();
    private static ConnectionImpl instance;
    private final ConnectivityManager connectivityManager;
    private ConnectionStateReceiver receiver;
    private final AtomicBoolean receiverRegistered = new AtomicBoolean(false);
    private ActualConnection actualConnection = new ActualConnection(Connection.ConnectionType.UNAVAILABLE, false);
    private final List<Connection.OnConnectionListener> listeners = new ArrayList<Connection.OnConnectionListener>(2);

    private ConnectionImpl(Context applicationContext) {
        this.connectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static ConnectionImpl getsInstance(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new ConnectionImpl(context.getApplicationContext());
            }
        }
        return instance;
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedOrConnecting() {
        NetworkInfo info = this.connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnectedOrConnecting();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected() {
        NetworkInfo info = this.connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedOrConnecting(@NonNull Connection.ConnectionType connectionType) {
        NetworkInfo info = this.connectivityManager.getNetworkInfo(connectionType.systemConstant);
        return info != null && info.isConnectedOrConnecting();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected(@NonNull Connection.ConnectionType connectionType) {
        NetworkInfo info = this.connectivityManager.getNetworkInfo(connectionType.systemConstant);
        return info != null && info.isConnected();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isAvailable(@NonNull Connection.ConnectionType connectionType) {
        NetworkInfo info = this.connectivityManager.getNetworkInfo(connectionType.systemConstant);
        return info != null && info.isAvailable();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @NonNull
    public Connection.ConnectionType getConnectionType() {
        NetworkInfo info = this.connectivityManager.getActiveNetworkInfo();
        return info == null || !info.isConnected() ? Connection.ConnectionType.UNAVAILABLE : Connection.ConnectionType.resolve(info.getType());
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @Nullable
    public NetworkInfo getConnectionInfo(@NonNull Connection.ConnectionType type) {
        return this.connectivityManager.getNetworkInfo(type.systemConstant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnConnectionListener(@NonNull Connection.OnConnectionListener listener) {
        List<Connection.OnConnectionListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnConnectionListener(@NonNull Connection.OnConnectionListener listener) {
        List<Connection.OnConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionReceiver(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (!this.receiverRegistered.get()) {
                this.receiverRegistered.set(true);
                this.receiver = new ConnectionStateReceiver();
                context.registerReceiver((BroadcastReceiver)this.receiver, this.receiver.newIntentFilter());
            }
        }
    }

    @Override
    public boolean isConnectionReceiverRegistered() {
        return this.receiverRegistered.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionReceiver(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (this.receiverRegistered.get()) {
                context.unregisterReceiver((BroadcastReceiver)this.receiver);
                this.receiverRegistered.set(false);
                this.receiver = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    void handleBroadcast(@NonNull Context context, @NonNull Intent intent) {
        if (this.isConnected()) {
            Connection.ConnectionType type = this.getConnectionType();
            ActualConnection connection = new ActualConnection(type, true);
            if (!connection.equals(this.actualConnection)) {
                this.actualConnection = connection;
                NetworkInfo info = this.getConnectionInfo(type);
                List<Connection.OnConnectionListener> list = this.listeners;
                synchronized (list) {
                    if (!this.listeners.isEmpty()) {
                        for (Connection.OnConnectionListener listener : this.listeners) {
                            listener.onConnectionEstablished(context, type, info);
                        }
                    }
                }
            }
        } else if (this.actualConnection != null) {
            Connection.ConnectionType lostType = Connection.ConnectionType.values()[this.actualConnection.type.ordinal()];
            this.actualConnection = new ActualConnection(Connection.ConnectionType.UNAVAILABLE, false);
            List<Connection.OnConnectionListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.isEmpty()) {
                    for (Connection.OnConnectionListener listener : this.listeners) {
                        listener.onConnectionLost(context, lostType);
                    }
                }
            }
        }
    }

    private static final class ActualConnection {
        Connection.ConnectionType type;
        boolean connected;

        ActualConnection(Connection.ConnectionType type, boolean connected) {
            this.type = type;
            this.connected = connected;
        }

        public int hashCode() {
            int hash = this.connected ? 1 : 0;
            hash = 31 * hash + this.type.hashCode();
            return hash;
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ActualConnection)) {
                return false;
            }
            ActualConnection connection = (ActualConnection)other;
            if (!this.type.equals((Object)connection.type)) {
                return false;
            }
            return this.connected == connection.connected;
        }
    }
}

