/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import universum.studios.android.device.storage.StorageEditor;

public final class StorageUtils {
    private static final String TAG = "StorageUtils";
    private static final Object LOCK = new Object();
    private static final StorageEditor EDITOR = new StorageEditor();

    private StorageUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean fileExists(@NonNull String path) {
        return new File(path).isFile();
    }

    public static boolean directoryExists(@NonNull String path) {
        return new File(path).isDirectory();
    }

    public static boolean isDirectoryEmpty(@NonNull String path) {
        File file = new File(path);
        return file.isDirectory() && file.list().length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createFile(@NonNull String path) {
        File file = new File(path);
        Object object = LOCK;
        synchronized (object) {
            if (!file.exists()) {
                Uri fileUri = Uri.parse((String)path);
                File parentDirs = new File(fileUri.getPath().replace(fileUri.getLastPathSegment(), ""));
                if (!(parentDirs.exists() && parentDirs.isDirectory() || parentDirs.mkdirs())) {
                    Log.e((String)TAG, (String)("Failed to create parent directories for file('" + path + "')."));
                    return false;
                }
                try {
                    return file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return !file.isDirectory();
        }
    }

    public static int createFiles(String ... paths) {
        return StorageUtils.createFiles("", paths);
    }

    public static int createFiles(@Nullable String basePath, String ... paths) {
        if (paths.length > 0) {
            int count = 0;
            for (String path : paths) {
                if (!StorageUtils.createFile(basePath + path)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDirectory(@NonNull String path) {
        File file = new File(path);
        Object object = LOCK;
        synchronized (object) {
            return file.isDirectory() || file.mkdirs();
        }
    }

    public static int createDirectories(String ... paths) {
        return StorageUtils.createDirectories("", paths);
    }

    public static int createDirectories(@Nullable String basePath, String ... paths) {
        if (paths.length > 0) {
            int count = 0;
            for (String path : paths) {
                if (!StorageUtils.createDirectory(basePath + path)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFile(@NonNull String path) {
        File file = new File(path);
        Object object = LOCK;
        synchronized (object) {
            return file.isFile() && file.delete();
        }
    }

    public static int deleteFiles(String ... paths) {
        return StorageUtils.deleteFiles("", paths);
    }

    public static int deleteFiles(@Nullable String basePath, String ... paths) {
        if (paths.length > 0) {
            int count = 0;
            for (String path : paths) {
                if (!StorageUtils.deleteFile(basePath + path)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static boolean deleteDirectory(@NonNull String path) {
        return StorageUtils.deleteDirectory(null, null, path);
    }

    public static boolean deleteDirectory(@Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @NonNull String path) {
        return EDITOR.deleteDirectory(new File(path), filter, nameFilter);
    }

    public static int deleteDirectories(String ... paths) {
        return StorageUtils.deleteDirectories("", paths);
    }

    public static int deleteDirectories(@Nullable String basePath, String ... paths) {
        return StorageUtils.deleteDirectories(null, null, basePath, paths);
    }

    public static int deleteDirectories(@Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String basePath, String ... paths) {
        if (paths.length > 0) {
            int count = 0;
            for (String path : paths) {
                if (!StorageUtils.deleteDirectory(filter, nameFilter, basePath + path)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static boolean copyFile(int flags, @Nullable String toPath, @NonNull String fromPath) throws IOException {
        return EDITOR.copyFileContent(flags, new File(fromPath), new File(StorageUtils.appendDestinationPathWithFileName(toPath, fromPath)));
    }

    public static int copyFiles(int flags, @Nullable String toPath, String ... fromPaths) throws IOException {
        if (fromPaths.length > 0) {
            int count = 0;
            for (String fromPath : fromPaths) {
                if (!StorageUtils.copyFile(flags, toPath, fromPath)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static boolean copyDirectory(int flags, @Nullable String toPath, @NonNull String fromPath) throws IOException {
        return StorageUtils.copyDirectory(flags, null, null, toPath, fromPath);
    }

    public static boolean copyDirectory(int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, @NonNull String fromPath) throws IOException {
        return EDITOR.copyDirectoryContent(flags, new File(fromPath), new File(StorageUtils.appendDestinationPathWithFileName(toPath, fromPath)), filter, nameFilter);
    }

    public static int copyDirectories(int flags, @Nullable String toPath, String ... fromPaths) throws IOException {
        return StorageUtils.copyDirectories(flags, null, null, toPath, fromPaths);
    }

    public static int copyDirectories(int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, String ... fromPaths) throws IOException {
        if (fromPaths.length > 0) {
            int count = 0;
            for (String fromPath : fromPaths) {
                if (!StorageUtils.copyDirectory(flags, filter, nameFilter, toPath, fromPath)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static boolean moveFile(int flags, @Nullable String toPath, @NonNull String fromPath) throws IOException {
        return EDITOR.moveFileContent(flags, new File(fromPath), new File(StorageUtils.appendDestinationPathWithFileName(toPath, fromPath)));
    }

    public static int moveFiles(int flags, @Nullable String toPath, String ... fromPaths) throws IOException {
        if (fromPaths.length > 0) {
            int count = 0;
            for (String fromPath : fromPaths) {
                if (!StorageUtils.copyFile(flags, toPath, fromPath)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static boolean moveDirectory(int flags, @Nullable String toPath, @NonNull String fromPath) throws IOException {
        return StorageUtils.moveDirectory(flags, null, null, toPath, fromPath);
    }

    public static boolean moveDirectory(int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, @NonNull String fromPath) throws IOException {
        return EDITOR.moveDirectoryContent(flags, new File(fromPath), new File(StorageUtils.appendDestinationPathWithFileName(toPath, fromPath)), filter, nameFilter);
    }

    public static int moveDirectories(int flags, @Nullable String toPath, String ... fromPaths) throws IOException {
        return StorageUtils.moveDirectories(flags, null, null, toPath, fromPaths);
    }

    public static int moveDirectories(int flags, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter, @Nullable String toPath, String ... fromPaths) throws IOException {
        if (fromPaths.length > 0) {
            int count = 0;
            for (String fromPath : fromPaths) {
                if (!StorageUtils.moveDirectory(flags, filter, nameFilter, toPath, fromPath)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    private static String appendDestinationPathWithFileName(String destinationPath, String filePath) {
        if (TextUtils.isEmpty((CharSequence)destinationPath)) {
            return "";
        }
        String lastPathSegment = Uri.parse((String)filePath).getLastPathSegment();
        return TextUtils.isEmpty((CharSequence)lastPathSegment) ? destinationPath : destinationPath + File.separator + lastPathSegment;
    }
}

