/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StorageEditor {
    private static final String TAG = "StorageEditor";
    public static final int DEFAULT = 0;
    public static final int OVERWRITE = 1;
    public static final int COPY = 2;
    public static final int SMALL_BUFFER = 1;
    public static final int MEDIUM_BUFFER = 2;
    public static final int LARGE_BUFFER = 4;
    public static final int XLARGE_BUFFER = 8;
    public static final int XXLARGE_BUFFER = 16;
    public static final String COPY_SUFFIX = "-Copy";
    private static final int BASE_BUFFER_SIZE = 512;
    private static final Object LOCK = new Object();
    private final Matcher mFileNameMatcher = Pattern.compile("^(.*)\\.(.+)$").matcher("");

    @NonNull
    public static byte[] createBuffer(int bufferType) {
        switch (bufferType) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return new byte[bufferType * 512];
            }
        }
        return new byte[1024];
    }

    public boolean deleteDirectory(@NonNull File directory) {
        return this.deleteDirectory(directory, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDirectory(@NonNull File directory, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter) {
        Object object = LOCK;
        synchronized (object) {
            return directory.isDirectory() && this.deleteDirectoryContentInner(directory, filter, nameFilter);
        }
    }

    private boolean deleteDirectoryContentInner(File directory, FileFilter filter, FilenameFilter nameFilter) {
        File[] files = directory.listFiles();
        boolean failed = false;
        if (files.length > 0) {
            for (File file : files) {
                if (filter != null && !filter.accept(file) || nameFilter != null && !nameFilter.accept(file, file.getName())) continue;
                boolean isDir = file.isDirectory();
                if (isDir && !this.deleteDirectoryContentInner(file, filter, nameFilter)) {
                    StorageEditor.logError("Failed to delete directory('" + file.getName() + "').");
                    failed = true;
                    continue;
                }
                if (isDir || file.delete()) continue;
                StorageEditor.logError("Failed to delete file('" + file.getName() + "').");
                failed = true;
            }
        }
        if (directory.listFiles().length == 0 && (filter == null && nameFilter == null || filter != null && filter.accept(directory) || nameFilter != null && nameFilter.accept(directory, directory.getName())) && !directory.delete()) {
            failed = true;
        }
        return !failed;
    }

    public boolean copyFileContent(@NonNull File file) throws IOException {
        return this.copyFileContent(2, file, null);
    }

    public boolean copyFileContent(int flags, @NonNull File fromFile, @Nullable File toFile) throws IOException {
        if (!fromFile.isFile()) {
            throw new FileNotFoundException("Cannot copy content of file(" + fromFile.getPath() + "). Such a file doesn't exist or it is a directory.");
        }
        if (toFile != null && toFile.isDirectory()) {
            throw new IllegalArgumentException("Cannot copy content to file(" + toFile.getPath() + "). Destination already exists and it is a directory not a file.");
        }
        return this.copyFileContentInner(flags, fromFile, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFileContentInner(int flags, File fromFile, File toFile) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            String toFilePath;
            String string = toFilePath = toFile == null ? "" : toFile.getPath();
            if (TextUtils.isEmpty((CharSequence)toFilePath)) {
                if ((flags & 2) == 0) {
                    StorageEditor.logError("Failed to copy content of file('" + fromFile.getPath() + "') without StorageEditor.COPY flag. Such a file already exists.");
                    return false;
                }
                toFilePath = this.appendPath(fromFile, COPY_SUFFIX).getPath();
            } else if (toFile != null && toFile.exists()) {
                boolean overwrite;
                boolean copy = (flags & 2) != 0;
                boolean bl = overwrite = (flags & 1) != 0;
                if (!copy && !overwrite) {
                    StorageEditor.logError("Failed to copy content to file('" + toFilePath + "') without StorageEditor.COPY or StorageEditor.OVERWRITE flag. Such a file already exists.");
                    return false;
                }
                if (copy) {
                    toFilePath = this.appendPath(toFile, COPY_SUFFIX).getPath();
                }
            }
            toFile = StorageEditor.createAndGetFile(toFilePath);
            if (toFile == null) {
                return false;
            }
            FileInputStream input = new FileInputStream(fromFile);
            FileOutputStream output = new FileOutputStream(toFile);
            this.copyFileStreams(input, output);
            input.close();
            output.close();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createAndGetFile(String path) {
        File file = new File(path);
        Object object = LOCK;
        synchronized (object) {
            if (file.isFile()) {
                return file;
            }
            if (!file.exists()) {
                Uri fileUri = Uri.parse((String)path);
                File parentDirs = new File(fileUri.getPath().replace(fileUri.getLastPathSegment(), ""));
                if (!(parentDirs.exists() && parentDirs.isDirectory() || parentDirs.mkdirs())) {
                    StorageEditor.logError("Failed to create parent directories for file('" + path + "').");
                    return null;
                }
                try {
                    return file.createNewFile() ? file : null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    public boolean copyDirectoryContent(@NonNull File directory) throws IOException {
        return this.copyDirectoryContent(2, directory, null);
    }

    public boolean copyDirectoryContent(int flags, @NonNull File fromDirectory, @Nullable File toDirectory) throws IOException {
        return this.copyDirectoryContent(flags, fromDirectory, toDirectory, null, null);
    }

    public boolean copyDirectoryContent(int flags, @NonNull File fromDirectory, @Nullable File toDirectory, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter) throws IOException {
        if (!fromDirectory.isDirectory()) {
            throw new FileNotFoundException("Cannot copy content of directory(" + fromDirectory.getPath() + "). Such a directory doesn't exist or it is a file.");
        }
        if (toDirectory != null && toDirectory.isFile()) {
            throw new IllegalArgumentException("Cannot copy content to directory(" + toDirectory.getPath() + "). Destination already exists and it is a file not a directory.");
        }
        return this.copyDirectoryContentInner(flags, fromDirectory, toDirectory, filter, nameFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDirectoryContentInner(int flags, File fromDirectory, File toDirectory, FileFilter filter, FilenameFilter nameFilter) throws IOException {
        File[] files = fromDirectory.listFiles();
        String toDirectoryPath = toDirectory == null ? "" : toDirectory.getPath();
        boolean failed = false;
        if (files.length > 0) {
            Object object = LOCK;
            synchronized (object) {
                for (File file : files) {
                    if (filter != null && !filter.accept(file) || nameFilter != null && !nameFilter.accept(file, file.getName())) continue;
                    File tempFile = new File(this.appendPathWithFilename(toDirectoryPath, file.getName()));
                    if (file.isDirectory()) {
                        if (this.copyDirectoryContentInner(flags, file, tempFile, filter, nameFilter)) continue;
                        StorageEditor.logError("Failed to copy content of directory('" + file.getPath() + "').");
                        failed = true;
                        continue;
                    }
                    if (!file.isFile() || this.copyFileContentInner(flags, file, tempFile)) continue;
                    StorageEditor.logError("Failed to copy content of file('" + file.getPath() + "').");
                    failed = true;
                }
            }
        }
        Object object = LOCK;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)toDirectoryPath)) {
                if ((flags & 2) == 0) {
                    StorageEditor.logError("Failed to copy content of directory('" + fromDirectory.getPath() + "') without StorageEditor.COPY flag. Such a directory already exists.");
                    failed = true;
                } else {
                    toDirectoryPath = this.appendPath(fromDirectory, COPY_SUFFIX).getPath();
                }
            } else if (toDirectory != null && toDirectory.exists()) {
                if ((flags & 2) == 0) {
                    StorageEditor.logError("Failed to copy content to directory('" + toDirectoryPath + "') without StorageEditor.COPY flag. Such a directory already exists.");
                    failed = true;
                } else {
                    toDirectoryPath = this.appendPath(toDirectory, COPY_SUFFIX).getPath();
                }
            }
            if (!failed) {
                File toDir = new File(toDirectoryPath);
                if (filter != null && !filter.accept(toDir) || nameFilter != null && !nameFilter.accept(toDir, toDir.getName())) {
                    return true;
                }
                if (!toDir.exists() && !StorageEditor.createDirectory(toDirectoryPath)) {
                    StorageEditor.logError("Failed to create directory('" + toDirectoryPath + "').");
                    failed = true;
                }
            }
        }
        return !failed;
    }

    private String appendPathWithFilename(String path, String filename) {
        return TextUtils.isEmpty((CharSequence)path) ? "" : path + File.separator + filename;
    }

    private File appendPath(File file, String suffix) {
        String filePath = file.getPath();
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return file;
        }
        if (file.isDirectory()) {
            return new File(filePath + suffix);
        }
        String lastPathSegment = Uri.parse((String)filePath).getLastPathSegment();
        if (this.mFileNameMatcher.reset(lastPathSegment).matches()) {
            String fileType = this.mFileNameMatcher.group(2);
            filePath = filePath.substring(0, filePath.length() - fileType.length() - 1);
            return new File(filePath + suffix + "." + fileType);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createDirectory(String path) {
        File file = new File(path);
        Object object = LOCK;
        synchronized (object) {
            return file.isDirectory() || file.mkdirs();
        }
    }

    public boolean moveFileContent(int flags, @NonNull File fromFile, @Nullable File toFile) throws IOException {
        if (!fromFile.isFile()) {
            throw new FileNotFoundException("Cannot move content of file(" + fromFile.getPath() + "). Such a file doesn't exist or it is a directory.");
        }
        if (toFile != null && toFile.isDirectory()) {
            throw new IllegalArgumentException("Cannot move content to file(" + toFile.getPath() + "). Destination already exists and it is a directory not a file.");
        }
        return this.moveFileContentInner(flags, fromFile, toFile);
    }

    private boolean moveFileContentInner(int flags, File fromFile, File toFile) throws IOException {
        return this.copyFileContentInner(flags, fromFile, toFile) && fromFile.delete();
    }

    public boolean moveDirectoryContent(int flags, @NonNull File fromDirectory, @Nullable File toDirectory) throws IOException {
        return this.moveDirectoryContent(flags, fromDirectory, toDirectory, null, null);
    }

    public boolean moveDirectoryContent(int flags, @NonNull File fromDirectory, @Nullable File toDirectory, @Nullable FileFilter filter, @Nullable FilenameFilter nameFilter) throws IOException {
        if (!fromDirectory.isDirectory()) {
            throw new FileNotFoundException("Cannot move content of directory(" + fromDirectory.getPath() + "). Such a directory doesn't exist or it is a file.");
        }
        if (toDirectory != null) {
            if (toDirectory.isFile()) {
                throw new IllegalArgumentException("Cannot move content to directory(" + toDirectory.getPath() + "). Destination already exists and it is a file not a directory.");
            }
            File parent = toDirectory.getParentFile();
            String directoryPath = fromDirectory.getPath();
            if (parent != null && directoryPath.equals(parent.getPath())) {
                throw new UnsupportedOperationException("Cannot move directory('" + directoryPath + "') to itself.");
            }
        }
        return this.moveDirectoryContentInner(flags, fromDirectory, toDirectory, filter, nameFilter);
    }

    private boolean moveDirectoryContentInner(int flags, File fromDirectory, File toDirectory, FileFilter filter, FilenameFilter nameFilter) throws IOException {
        return this.copyDirectoryContentInner(flags, fromDirectory, toDirectory, filter, nameFilter) && this.deleteDirectory(fromDirectory, filter, nameFilter);
    }

    public boolean copyFileStreams(@NonNull FileInputStream inputStream, @NonNull FileOutputStream outputStream) throws IOException {
        return this.copyFileStreams(inputStream, outputStream, 2);
    }

    public boolean copyFileStreams(@NonNull FileInputStream inputStream, @NonNull FileOutputStream outputStream, int bufferType) throws IOException {
        return this.copyFileStreams(inputStream, outputStream, StorageEditor.createBuffer(bufferType));
    }

    public boolean copyFileStreams(@NonNull FileInputStream inputStream, @NonNull FileOutputStream outputStream, byte[] buffer) throws IOException {
        int bytes;
        while ((bytes = inputStream.read(buffer, 0, buffer.length)) > 0) {
            outputStream.write(buffer, 0, bytes);
        }
        inputStream.close();
        outputStream.close();
        return true;
    }

    private static void logError(String errorMessage) {
        Log.e((String)TAG, (String)errorMessage);
    }
}

