/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.storage;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import universum.studios.android.device.storage.StorageImpl;

public interface Storage {
    public static final Provider PROVIDER = new Provider(){

        @Override
        @NonNull
        public Storage getStorage(@NonNull Context context) {
            return StorageImpl.getInstance(context);
        }
    };
    public static final int NO_FLAGS = -1;
    public static final int DEFAULT = 0;
    public static final int OVERWRITE = 1;
    public static final int COPY = 2;
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_WRITE = 2;
    public static final int PERMISSION_EXECUTE = 4;
    public static final int PERMISSIONS_READ_WRITE = 3;
    public static final int PERMISSIONS_ALL = 7;
    public static final int BASE = 0;
    public static final int ROOT = 1;
    public static final int DATA = 2;
    public static final int CACHE = 4;
    public static final int INTERNAL = 5;
    public static final int EXTERNAL = 6;
    public static final int EXTERNAL_PACKAGE = 7;
    public static final int ACTION_CREATE = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_COPY = 3;
    public static final int ACTION_MOVE = 4;
    public static final int NO_ERROR = 0;
    public static final int ERROR_EMPTY_REQUEST = 0;
    public static final int ERROR_IO = -1;
    public static final int ERROR_UNSUPPORTED_OPERATION = -2;
    public static final int ERROR_API = -3;
    public static final int ERROR_FILE_NOT_FOUND = -17;
    public static final int ERROR_FILE_SAME_AS_DIRECTORY = -18;
    public static final int ERROR_DIRECTORY_SAME_AS_FILE = -19;
    public static final int KILO = 128;

    @NonNull
    public Result createFile(@NonNull String var1);

    @NonNull
    public Result createFile(int var1, @NonNull String var2);

    @NonNull
    public Results createFiles(String ... var1);

    @NonNull
    public Results createFiles(int var1, String ... var2);

    @NonNull
    public Result createDirectory(@NonNull String var1);

    @NonNull
    public Result createDirectory(int var1, @NonNull String var2);

    @NonNull
    public Results createDirectories(String ... var1);

    @NonNull
    public Results createDirectories(int var1, String ... var2);

    @NonNull
    public Result deleteFile(@NonNull String var1);

    @NonNull
    public Result deleteFile(int var1, @NonNull String var2);

    @NonNull
    public Results deleteFiles(String ... var1);

    @NonNull
    public Results deleteFiles(int var1, String ... var2);

    @NonNull
    public Result deleteDirectory(@NonNull String var1);

    @NonNull
    public Result deleteDirectory(int var1, @NonNull String var2);

    @NonNull
    public Result deleteDirectory(int var1, @Nullable FileFilter var2, @Nullable FilenameFilter var3, @NonNull String var4);

    @NonNull
    public Results deleteDirectories(String ... var1);

    @NonNull
    public Results deleteDirectories(int var1, String ... var2);

    @NonNull
    public Results deleteDirectories(int var1, @Nullable FileFilter var2, @Nullable FilenameFilter var3, String ... var4);

    @NonNull
    public Result deleteFileOrDirectory(@NonNull String var1);

    @NonNull
    public Result deleteFileOrDirectory(int var1, @NonNull String var2);

    @NonNull
    public Result deleteFileOrDirectory(int var1, @Nullable FileFilter var2, @Nullable FilenameFilter var3, @NonNull String var4);

    @NonNull
    public Results deleteFilesOrDirectories(String ... var1);

    @NonNull
    public Results deleteFilesOrDirectories(int var1, String ... var2);

    @NonNull
    public Results deleteFilesOrDirectories(int var1, @Nullable FileFilter var2, @Nullable FilenameFilter var3, String ... var4);

    @NonNull
    public Result copyFile(int var1, @Nullable String var2, @NonNull String var3);

    @NonNull
    public Result copyFile(int var1, int var2, @Nullable String var3, @NonNull String var4);

    @NonNull
    public Results copyFiles(int var1, @Nullable String var2, String ... var3);

    @NonNull
    public Results copyFiles(int var1, int var2, @Nullable String var3, String ... var4);

    @NonNull
    public Result copyDirectory(int var1, @Nullable String var2, @NonNull String var3);

    @NonNull
    public Result copyDirectory(int var1, int var2, @Nullable String var3, @NonNull String var4);

    @NonNull
    public Result copyDirectory(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, @NonNull String var6);

    @NonNull
    public Results copyDirectories(int var1, @Nullable String var2, String ... var3);

    @NonNull
    public Results copyDirectories(int var1, int var2, @Nullable String var3, String ... var4);

    @NonNull
    public Results copyDirectories(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, String ... var6);

    @NonNull
    public Result copyFileOrDirectory(int var1, @Nullable String var2, @NonNull String var3);

    @NonNull
    public Result copyFileOrDirectory(int var1, int var2, @Nullable String var3, @NonNull String var4);

    @NonNull
    public Result copyFileOrDirectory(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, @NonNull String var6);

    @NonNull
    public Results copyFilesOrDirectories(int var1, @Nullable String var2, String ... var3);

    @NonNull
    public Results copyFilesOrDirectories(int var1, int var2, @Nullable String var3, String ... var4);

    @NonNull
    public Results copyFilesOrDirectories(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, String ... var6);

    @NonNull
    public Result moveFile(int var1, @Nullable String var2, @NonNull String var3);

    @NonNull
    public Result moveFile(int var1, int var2, @Nullable String var3, @NonNull String var4);

    @NonNull
    public Results moveFiles(int var1, @Nullable String var2, String ... var3);

    @NonNull
    public Results moveFiles(int var1, int var2, @Nullable String var3, String ... var4);

    @NonNull
    public Result moveDirectory(int var1, @Nullable String var2, @NonNull String var3);

    @NonNull
    public Result moveDirectory(int var1, int var2, @Nullable String var3, @NonNull String var4);

    @NonNull
    public Result moveDirectory(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, @NonNull String var6);

    @NonNull
    public Results moveDirectories(int var1, @Nullable String var2, String ... var3);

    @NonNull
    public Results moveDirectories(int var1, int var2, @Nullable String var3, String ... var4);

    @NonNull
    public Results moveDirectories(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, String ... var6);

    @NonNull
    public Result moveFileOrDirectory(int var1, @Nullable String var2, @NonNull String var3);

    @NonNull
    public Result moveFileOrDirectory(int var1, int var2, @Nullable String var3, @NonNull String var4);

    @NonNull
    public Result moveFileOrDirectory(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, @NonNull String var6);

    @NonNull
    public Results moveFilesOrDirectories(int var1, @Nullable String var2, String ... var3);

    @NonNull
    public Results moveFilesOrDirectories(int var1, int var2, @Nullable String var3, String ... var4);

    @NonNull
    public Results moveFilesOrDirectories(int var1, int var2, @Nullable FileFilter var3, @Nullable FilenameFilter var4, @Nullable String var5, String ... var6);

    public boolean changeFilePermissions(@NonNull String var1, int var2, boolean var3);

    public boolean changeFilePermissions(int var1, @NonNull String var2, int var3, boolean var4);

    public boolean isExternalMounted();

    public boolean isExternalReadOnly();

    public boolean isExternalAvailable();

    public boolean hasFreeSpace(int var1, long var2);

    public long getFreeSpace(int var1);

    @Nullable
    public File getStorage(int var1);

    @NonNull
    public String getStoragePath(int var1);

    @NonNull
    public File getFile(int var1, @NonNull String var2);

    @NonNull
    public List<File> getDirectoryContent(@NonNull String var1);

    @NonNull
    public List<File> getDirectoryContent(int var1, @NonNull String var2);

    @NonNull
    public List<File> getDirectoryContent(int var1, @Nullable FileFilter var2, @Nullable FilenameFilter var3, @NonNull String var4);

    @NonNull
    public List<File> getDirectoriesContent(String ... var1);

    @NonNull
    public List<File> getDirectoriesContent(int var1, String ... var2);

    @NonNull
    public List<File> getDirectoriesContent(int var1, @Nullable FileFilter var2, @Nullable FilenameFilter var3, String ... var4);

    public static final class Results
    extends BaseResult {
        public final int succeeded;
        @NonNull
        public final List<Result> results;

        Results(int action, @NonNull String message, int succeeded, @NonNull List<Result> results, int flags, int error) {
            super(action, message, flags, error);
            this.succeeded = succeeded;
            this.results = results;
        }
    }

    public static final class Result
    extends BaseResult {
        @NonNull
        public final String path;

        Result(int action, String message, @NonNull String path, int flags, int error) {
            super(action, message, flags, error);
            this.path = path;
        }
    }

    public static abstract class BaseResult {
        public final int action;
        @NonNull
        public final String message;
        public final int flags;
        public final boolean isError;
        public final int errorCode;

        BaseResult(int action, @NonNull String message, int flags, int error) {
            this.action = action;
            this.message = message;
            this.flags = flags;
            this.errorCode = error;
            this.isError = error < 0;
        }
    }

    public static enum Unit {
        b("Bit", 1L),
        B("Byte", 8L * Unit.b.bits),
        Kb("Kilobit", 128L * Unit.B.bits),
        KB("Kilobyte", Unit.B.bits * Unit.Kb.bits),
        Mb("Megabit", 128L * Unit.KB.bits),
        MB("Megabyte", Unit.B.bits * Unit.Mb.bits),
        Gb("Gigabit", 128L * Unit.MB.bits),
        GB("Gigabyte", Unit.B.bits * Unit.Gb.bits),
        Tb("Terabit", 128L * Unit.GB.bits),
        TB("Terabyte", Unit.B.bits * Unit.Tb.bits),
        Pb("Petabit", 128L * Unit.TB.bits),
        PB("Petabyte", Unit.B.bits * Unit.Pb.bits);

        public final String fullName;
        public final long bits;
        public final float bytes;

        private Unit(String fullName, long bits) {
            this.fullName = fullName;
            this.bits = bits;
            this.bytes = (float)bits / 8.0f;
        }

        public float formatBits(long bits) {
            return (float)bits / (float)this.bits;
        }

        public float formatBytes(long bytes) {
            return (float)bytes / this.bytes;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StorageDir {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FilePermissions {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    public static interface Provider {
        @NonNull
        public Storage getStorage(@NonNull Context var1);
    }
}

