/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.screen;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Px;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import universum.studios.android.device.screen.Screen;

final class ScreenImpl
implements Screen {
    private static final Object LOCK = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static ScreenImpl sInstance;
    private final DisplayMetrics mMetrics = new DisplayMetrics();
    private final Context mContext;
    private final int mWidth;
    private final int mHeight;
    private final WindowManager mWindowManager;
    private final int mDefaultOrientation;
    private final Screen.ScreenType mType;
    private final Screen.ScreenDensity mDensity;
    private final int mRawDensity;
    private int mCurrentOrientation = -1;
    private Screen.ScreenRotation mCurrentRotation = Screen.ScreenRotation.UNKNOWN;
    private int mCurrentWidth;
    private int mCurrentHeight;
    private boolean mOrientationLocked;

    private ScreenImpl(Context applicationContext) {
        boolean reverse;
        float defaultHeightDP;
        float defaultWidthDP;
        this.mContext = applicationContext;
        this.mWindowManager = (WindowManager)applicationContext.getSystemService("window");
        this.refresh();
        block0 : switch (this.mCurrentRotation) {
            case ROTATION_0: 
            case ROTATION_180: {
                switch (this.mCurrentOrientation) {
                    case 0: 
                    case 8: {
                        this.mDefaultOrientation = 0;
                        break block0;
                    }
                    case 1: 
                    case 9: {
                        this.mDefaultOrientation = 1;
                        break block0;
                    }
                }
                this.mDefaultOrientation = -1;
                break;
            }
            case ROTATION_90: 
            case ROTATION_270: {
                switch (this.mCurrentOrientation) {
                    case 0: 
                    case 8: {
                        this.mDefaultOrientation = 1;
                        break block0;
                    }
                    case 1: 
                    case 9: {
                        this.mDefaultOrientation = 0;
                        break block0;
                    }
                }
                this.mDefaultOrientation = -1;
                break;
            }
            default: {
                this.mDefaultOrientation = -1;
            }
        }
        this.mRawDensity = this.mMetrics.densityDpi;
        this.mDensity = Screen.ScreenDensity.resolve(this.mRawDensity);
        switch (this.mCurrentOrientation) {
            case 0: 
            case 8: {
                defaultWidthDP = this.pixelToDP(this.mMetrics.heightPixels);
                defaultHeightDP = this.pixelToDP(this.mMetrics.widthPixels);
                break;
            }
            case 1: 
            case 9: {
                defaultWidthDP = this.pixelToDP(this.mMetrics.widthPixels);
                defaultHeightDP = this.pixelToDP(this.mMetrics.heightPixels);
                break;
            }
            default: {
                defaultWidthDP = this.pixelToDP(this.mMetrics.widthPixels);
                defaultHeightDP = this.pixelToDP(this.mMetrics.heightPixels);
            }
        }
        this.mType = Screen.ScreenType.resolve(defaultWidthDP, defaultHeightDP);
        switch (this.mDefaultOrientation) {
            case 1: {
                reverse = this.mCurrentOrientation != 1 && this.mCurrentOrientation != 9;
                break;
            }
            case 0: {
                reverse = this.mCurrentOrientation != 0 && this.mCurrentOrientation != 8;
                break;
            }
            default: {
                reverse = false;
            }
        }
        this.mCurrentWidth = this.mMetrics.widthPixels;
        this.mCurrentHeight = this.mMetrics.heightPixels;
        this.mWidth = reverse ? this.mCurrentHeight : this.mCurrentWidth;
        this.mHeight = reverse ? this.mCurrentWidth : this.mCurrentHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static ScreenImpl getsInstance(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new ScreenImpl(context.getApplicationContext());
            }
        }
        return sInstance;
    }

    @Override
    public boolean isOn() {
        PowerManager power = (PowerManager)this.mContext.getSystemService("power");
        return power != null && power.isScreenOn();
    }

    @Override
    @TargetApi(value=20)
    public boolean isInteractive() {
        PowerManager power = (PowerManager)this.mContext.getSystemService("power");
        return power != null && power.isInteractive();
    }

    @Override
    public boolean lockOrientation(@NonNull Activity activity) {
        return this.requestOrientation(activity, -2);
    }

    @Override
    public void unlockOrientation(@NonNull Activity activity) {
        this.requestOrientation(activity, 2);
    }

    @Override
    public boolean requestOrientation(@NonNull Activity activity, int orientation) {
        switch (orientation) {
            case -2: {
                activity.setRequestedOrientation(this.getCurrentOrientation());
                break;
            }
            case -1: {
                break;
            }
            default: {
                activity.setRequestedOrientation(orientation);
            }
        }
        this.mOrientationLocked = orientation != 2;
        return this.mOrientationLocked;
    }

    @Override
    public int getRequestedOrientation(@NonNull Activity activity) {
        return activity.getRequestedOrientation();
    }

    @Override
    @NonNull
    public Display getDisplay() {
        return this.mWindowManager.getDefaultDisplay();
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getCurrentWidth() {
        this.refresh();
        return this.mCurrentWidth;
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getCurrentHeight() {
        this.refresh();
        return this.mCurrentHeight;
    }

    @Override
    @NonNull
    public DisplayMetrics getMetrics() {
        this.refresh();
        return this.mMetrics;
    }

    @Override
    @NonNull
    public Screen.ScreenDensity getDensity() {
        return this.mDensity;
    }

    @Override
    public int getRawDensity() {
        return this.mRawDensity;
    }

    @Override
    @NonNull
    public Screen.ScreenType getType() {
        return this.mType;
    }

    @Override
    public int getCurrentOrientation() {
        this.refresh();
        return this.mCurrentOrientation;
    }

    @Override
    public int getDefaultOrientation() {
        return this.mDefaultOrientation;
    }

    @Override
    @NonNull
    public Screen.ScreenRotation getCurrentRotation() {
        this.refresh();
        return this.mCurrentRotation;
    }

    @Override
    @FloatRange(from=0.0)
    public float getDiagonalDistanceInInches() {
        this.refresh();
        return (float)Math.sqrt(Math.pow((float)this.mWidth / this.mMetrics.xdpi, 2.0) + Math.pow((float)this.mHeight / this.mMetrics.ydpi, 2.0));
    }

    @Override
    @Px
    @IntRange(from=0L)
    public int getDiagonalDistanceInPixels() {
        this.refresh();
        return Math.round((float)Math.sqrt(Math.pow(this.mWidth, 2.0) + Math.pow(this.mHeight, 2.0)));
    }

    @Override
    public float getRefreshRate() {
        return this.getDisplay().getRefreshRate();
    }

    @Override
    public int getBrightness(@NonNull Activity activity) {
        Window window = activity.getWindow();
        return Math.round(window.getAttributes().screenBrightness * 100.0f);
    }

    @Override
    public void setBrightness(@NonNull Activity activity, @IntRange(from=0L, to=100L) int brightness) {
        if (brightness < 0 || brightness > 100) {
            throw new IllegalArgumentException("Brightness value(" + brightness + ") is out of the range [0, 100].");
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.screenBrightness = (float)Math.max(1, brightness) / 100.0f;
        window.setAttributes(layoutParams);
    }

    @Override
    public int getSystemBrightness() {
        float brightness = 0.0f;
        try {
            brightness = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return Math.round(brightness / 255.0f * 100.0f);
    }

    @Override
    public boolean isOrientationLocked() {
        return this.mOrientationLocked;
    }

    @Override
    public float pixelToDP(@Px int pixel) {
        return (float)pixel / (this.mDensity.value / 160.0f);
    }

    @Override
    @Px
    public int dpToPixel(float dp) {
        return Math.round(dp * (this.mDensity.value / 160.0f));
    }

    @Override
    public float getScreenDP() {
        return this.mDensity.value / 160.0f;
    }

    private void refresh() {
        this.getDisplay().getMetrics(this.mMetrics);
        if (this.mCurrentWidth != this.mMetrics.widthPixels || this.mCurrentHeight != this.mMetrics.heightPixels) {
            this.onRefresh();
        }
    }

    private void onRefresh() {
        int orientation = -1;
        this.mCurrentRotation = Screen.ScreenRotation.resolve(this.getDisplay().getRotation());
        block0 : switch (this.mContext.getResources().getConfiguration().orientation) {
            case 2: {
                switch (this.mCurrentRotation) {
                    case ROTATION_0: 
                    case ROTATION_90: {
                        orientation = 0;
                        break block0;
                    }
                    case ROTATION_180: 
                    case ROTATION_270: {
                        orientation = 8;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.mCurrentRotation) {
                    case ROTATION_0: 
                    case ROTATION_270: {
                        orientation = 1;
                        break block0;
                    }
                    case ROTATION_180: 
                    case ROTATION_90: {
                        orientation = 9;
                        break block0;
                    }
                }
                break;
            }
        }
        this.mCurrentOrientation = orientation;
        this.mCurrentWidth = this.mMetrics.widthPixels;
        this.mCurrentHeight = this.mMetrics.heightPixels;
    }
}

