/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.connection;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;

public final class ConnectionUtils {
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnectionEstablished(@NonNull Context context) {
        NetworkInfo info = ConnectionUtils.obtainEstablishedConnectionInfo(context);
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnectionEstablished(@NonNull Context context, int connectionType) {
        NetworkInfo info = ConnectionUtils.accessManager(context).getNetworkInfo(connectionType);
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnectionAvailable(@NonNull Context context, int connectionType) {
        NetworkInfo info = ConnectionUtils.accessManager(context).getNetworkInfo(connectionType);
        return info != null && info.isAvailable();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static int obtainEstablishedConnectionType(@NonNull Context context) {
        NetworkInfo info = ConnectionUtils.obtainEstablishedConnectionInfo(context);
        return info == null ? -1 : info.getType();
    }

    @Nullable
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static NetworkInfo obtainEstablishedConnectionInfo(@NonNull Context context) {
        return ConnectionUtils.accessManager(context).getActiveNetworkInfo();
    }

    private static ConnectivityManager accessManager(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    private ConnectionUtils() {
        throw new UnsupportedOperationException();
    }
}

