/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.connection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import universum.studios.android.device.connection.Connection;
import universum.studios.android.device.connection.ConnectionStateReceiver;

final class ConnectionImpl
implements Connection {
    private static final Object LOCK = new Object();
    private static ConnectionImpl sInstance;
    private final ConnectivityManager mConnectivityManager;
    private ConnectionStateReceiver mReceiver;
    private final AtomicBoolean mReceiverRegistered = new AtomicBoolean(false);
    private ActualConnection mActualConnection = new ActualConnection(Connection.ConnectionType.UNAVAILABLE, false);
    private final List<Connection.OnConnectionListener> mListeners = new ArrayList<Connection.OnConnectionListener>(2);

    private ConnectionImpl(Context applicationContext) {
        this.mConnectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static ConnectionImpl getsInstance(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new ConnectionImpl(context.getApplicationContext());
            }
        }
        return sInstance;
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedOrConnecting() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnectedOrConnecting();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedOrConnecting(@NonNull Connection.ConnectionType connectionType) {
        NetworkInfo info = this.mConnectivityManager.getNetworkInfo(connectionType.systemConstant);
        return info != null && info.isConnectedOrConnecting();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected(@NonNull Connection.ConnectionType connectionType) {
        NetworkInfo info = this.mConnectivityManager.getNetworkInfo(connectionType.systemConstant);
        return info != null && info.isConnected();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isAvailable(@NonNull Connection.ConnectionType connectionType) {
        NetworkInfo info = this.mConnectivityManager.getNetworkInfo(connectionType.systemConstant);
        return info != null && info.isAvailable();
    }

    @Override
    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public Connection.ConnectionType getConnectionType() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        return info == null || !info.isConnected() ? Connection.ConnectionType.UNAVAILABLE : Connection.ConnectionType.resolve(info.getType());
    }

    @Override
    @Nullable
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public NetworkInfo getConnectionInfo(@NonNull Connection.ConnectionType type) {
        return this.mConnectivityManager.getNetworkInfo(type.systemConstant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnConnectionListener(@NonNull Connection.OnConnectionListener listener) {
        List<Connection.OnConnectionListener> list = this.mListeners;
        synchronized (list) {
            if (!this.mListeners.contains(listener)) {
                this.mListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnConnectionListener(@NonNull Connection.OnConnectionListener listener) {
        List<Connection.OnConnectionListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionReceiver(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (!this.mReceiverRegistered.get()) {
                this.mReceiverRegistered.set(true);
                this.mReceiver = new ConnectionStateReceiver();
                context.registerReceiver((BroadcastReceiver)this.mReceiver, this.mReceiver.newIntentFilter());
            }
        }
    }

    @Override
    public boolean isConnectionReceiverRegistered() {
        return this.mReceiverRegistered.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionReceiver(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (this.mReceiverRegistered.get()) {
                context.unregisterReceiver((BroadcastReceiver)this.mReceiver);
                this.mReceiverRegistered.set(false);
                this.mReceiver = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    void handleBroadcast(@NonNull Context context, @NonNull Intent intent) {
        if (this.isConnected()) {
            Connection.ConnectionType type = this.getConnectionType();
            ActualConnection connection = new ActualConnection(type, true);
            if (!connection.equals(this.mActualConnection)) {
                this.mActualConnection = connection;
                NetworkInfo info = this.getConnectionInfo(type);
                List<Connection.OnConnectionListener> list = this.mListeners;
                synchronized (list) {
                    if (!this.mListeners.isEmpty()) {
                        for (Connection.OnConnectionListener listener : this.mListeners) {
                            listener.onConnectionEstablished(context, type, info);
                        }
                    }
                }
            }
        } else if (this.mActualConnection != null) {
            Connection.ConnectionType lostType = Connection.ConnectionType.values()[this.mActualConnection.type.ordinal()];
            this.mActualConnection = new ActualConnection(Connection.ConnectionType.UNAVAILABLE, false);
            List<Connection.OnConnectionListener> list = this.mListeners;
            synchronized (list) {
                if (!this.mListeners.isEmpty()) {
                    for (Connection.OnConnectionListener listener : this.mListeners) {
                        listener.onConnectionLost(context, lostType);
                    }
                }
            }
        }
    }

    private static final class ActualConnection {
        Connection.ConnectionType type = Connection.ConnectionType.UNAVAILABLE;
        boolean connected;

        ActualConnection(Connection.ConnectionType type, boolean connected) {
            this.type = type;
            this.connected = connected;
        }

        public int hashCode() {
            int hash = this.connected ? 1 : 0;
            hash = 31 * hash + this.type.hashCode();
            return hash;
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ActualConnection)) {
                return false;
            }
            ActualConnection connection = (ActualConnection)other;
            if (!this.type.equals((Object)connection.type)) {
                return false;
            }
            return this.connected == connection.connected;
        }
    }
}

