/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.connection;

import android.content.Context;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import universum.studios.android.device.connection.ConnectionImpl;

public interface Connection {
    public static final Provider PROVIDER = new Provider(){

        @Override
        @NonNull
        public Connection getConnection(@NonNull Context context) {
            return ConnectionImpl.getsInstance(context);
        }
    };

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedOrConnecting();

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected();

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedOrConnecting(@NonNull ConnectionType var1);

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected(@NonNull ConnectionType var1);

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isAvailable(@NonNull ConnectionType var1);

    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public ConnectionType getConnectionType();

    @Nullable
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public NetworkInfo getConnectionInfo(@NonNull ConnectionType var1);

    public void registerOnConnectionListener(@NonNull OnConnectionListener var1);

    public void unregisterOnConnectionListener(@NonNull OnConnectionListener var1);

    public void registerConnectionReceiver(@NonNull Context var1);

    public boolean isConnectionReceiverRegistered();

    public void unregisterConnectionReceiver(@NonNull Context var1);

    public static enum ConnectionType {
        UNAVAILABLE(-1, "Unavailable", "NETWORK_TYPE.UNAVAILABLE"),
        BLUETOOTH(7, "Bluetooth", "NETWORK_TYPE.BLUETOOTH"),
        DUMMY(8, "Dummy", "NETWORK_TYPE.DUMMY"),
        ETHERNET(9, "Ethernet", "NETWORK_TYPE.ETHERNET"),
        MOBILE(0, "Mobile", "NETWORK_TYPE.MOBILE"),
        MOBILE_DUN(4, "Mobile (DUN)", "NETWORK_TYPE.MOBILE_DUN"),
        MOBILE_HIPRI(5, "Mobile (HIPRI)", "NETWORK_TYPE.MOBILE_HIPRI"),
        MOBILE_MMS(2, "Mobile (MMS)", "NETWORK_TYPE.MOBILE_MMS"),
        MOBILE_SUPL(3, "Mobile (SUPL)", "NETWORK_TYPE.MOBILE_SUPL"),
        WIFI(1, "Wi-Fi", "NETWORK_TYPE.WIFI"),
        WIMAX(6, "WiMAX", "NETWORK_TYPE.WIMAX");

        public final int systemConstant;
        public final String originalName;
        public final String preferencesKey;

        private ConnectionType(int id, String origName, String prefsKey) {
            this.systemConstant = id;
            this.preferencesKey = prefsKey;
            this.originalName = origName;
        }

        @NonNull
        public static ConnectionType resolve(int systemConstant) {
            for (ConnectionType type : ConnectionType.values()) {
                if (type.systemConstant != systemConstant) continue;
                return type;
            }
            return UNAVAILABLE;
        }
    }

    public static interface OnConnectionListener {
        public void onConnectionEstablished(@NonNull Context var1, @NonNull ConnectionType var2, @Nullable NetworkInfo var3);

        public void onConnectionLost(@NonNull Context var1, @NonNull ConnectionType var2);
    }

    public static interface Provider {
        @NonNull
        public Connection getConnection(@NonNull Context var1);
    }
}

