/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.battery;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import universum.studios.android.device.battery.Battery;
import universum.studios.android.device.battery.BatteryHealthReceiver;
import universum.studios.android.device.battery.BatteryPluggedStateReceiver;
import universum.studios.android.device.battery.BatteryStatusReceiver;

final class BatteryImpl
implements Battery {
    private static final String TAG = "BatteryImpl";
    static final boolean DEBUG = false;
    private static final Object LOCK = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static BatteryImpl sInstance;
    private int mHealthLowLevel = 15;
    private int mHealthOkLevel = 20;
    private BatteryStatusReceiver mStatusReceiver;
    private BatteryHealthReceiver mHealthReceiver;
    private BatteryPluggedStateReceiver mPluggedStateReceiver;
    private final BatteryInfo mInfo = new BatteryInfo();
    private BatteryInfo mPrevInfo;
    private final List<Battery.OnStatusListener> mStatusListeners = new ArrayList<Battery.OnStatusListener>(2);
    private final List<Battery.OnHealthListener> mHealthListeners = new ArrayList<Battery.OnHealthListener>(2);
    private final List<Battery.OnPluggedStateListener> mPluggedStateListeners = new ArrayList<Battery.OnPluggedStateListener>(2);
    private final AtomicInteger mRegisteredReceivers = new AtomicInteger(0);
    private boolean mPersistentDataInitialized;
    private boolean mDataInitialized;

    private BatteryImpl(Context applicationContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static BatteryImpl getInstance(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new BatteryImpl(context.getApplicationContext());
            }
        }
        return sInstance;
    }

    @Override
    public boolean isCharging() {
        this.checkDataInitialization("charging state");
        int status = this.getStatus();
        return status == 2 || status == 5;
    }

    @Override
    public boolean isPlugged() {
        this.checkDataInitialization("plugged state");
        int state = this.getPluggedState();
        return state != -1 && state != 0;
    }

    @Override
    public boolean isLow() {
        return this.getStrength() <= this.getHealthLowLevel();
    }

    @Override
    @IntRange(from=0L, to=100L)
    public int getStrength() {
        this.checkDataInitialization("strength");
        return this.mInfo.strength();
    }

    @Override
    public int getStatus() {
        this.checkDataInitialization("status");
        return this.mInfo.status;
    }

    @Override
    public int getPluggedState() {
        this.checkDataInitialization("plugged state");
        return this.mInfo.pluggedState;
    }

    @Override
    public int getHealth() {
        this.checkDataInitialization("health");
        return this.mInfo.health;
    }

    @Override
    @NonNull
    public Battery.BatteryTechnology getTechnology() {
        this.checkDataInitialization("technology");
        return this.mInfo.technology;
    }

    @Override
    public float getTemperature() {
        this.checkDataInitialization("temperature");
        return (float)this.mInfo.temperature / 10.0f;
    }

    @Override
    public int getVoltage() {
        this.checkDataInitialization("voltage");
        return this.mInfo.voltage;
    }

    private boolean checkDataInitialization(String batteryInfo) {
        if (this.mDataInitialized || !this.isBatteryReceiverRegistered(1)) {
            // empty if block
        }
        return this.mDataInitialized;
    }

    @Override
    public void setHealthLowLevel(@IntRange(from=0L, to=100L) int level) {
        if (level >= 0 && level <= 100) {
            this.mHealthLowLevel = level;
        }
    }

    @Override
    @IntRange(from=0L, to=100L)
    public int getHealthLowLevel() {
        return this.mHealthLowLevel;
    }

    @Override
    public void setHealthOkLevel(int level) {
        if (level >= 0 && level <= 100) {
            this.mHealthOkLevel = level;
        }
    }

    @Override
    public int getHealthOkLevel() {
        return this.mHealthOkLevel;
    }

    private void bindBatteryData(Intent intent) {
        int scale;
        this.mPrevInfo = new BatteryInfo(this.mInfo);
        if (!this.mPersistentDataInitialized) {
            String technology = intent.getStringExtra("technology");
            this.mInfo.technology = Battery.BatteryTechnology.resolve(technology);
            this.mInfo.voltage = intent.getIntExtra("voltage", this.mInfo.voltage);
            this.mPersistentDataInitialized = true;
        }
        this.mInfo.status = intent.getIntExtra("status", this.mInfo.status);
        this.mInfo.temperature = intent.getIntExtra("temperature", this.mInfo.temperature);
        int level = intent.getIntExtra("level", -1);
        float strength = (float)level / (float)(scale = intent.getIntExtra("scale", 1));
        if (strength >= 0.0f) {
            this.mInfo.strength = strength;
        }
        this.mInfo.health = intent.getIntExtra("health", this.mInfo.health);
        this.mInfo.pluggedState = intent.getIntExtra("plugged", this.mInfo.pluggedState);
        this.mDataInitialized = true;
        this.mInfo.logCurrentData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnStatusListener(@NonNull Battery.OnStatusListener listener) {
        List<Battery.OnStatusListener> list = this.mStatusListeners;
        synchronized (list) {
            if (!this.mStatusListeners.contains(listener)) {
                this.mStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnStatusListener(@NonNull Battery.OnStatusListener listener) {
        List<Battery.OnStatusListener> list = this.mStatusListeners;
        synchronized (list) {
            this.mStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnHealthListener(@NonNull Battery.OnHealthListener listener) {
        List<Battery.OnHealthListener> list = this.mHealthListeners;
        synchronized (list) {
            if (!this.mHealthListeners.contains(listener)) {
                this.mHealthListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnHealthListener(@NonNull Battery.OnHealthListener listener) {
        List<Battery.OnHealthListener> list = this.mHealthListeners;
        synchronized (list) {
            this.mHealthListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnPluggedStateListener(@NonNull Battery.OnPluggedStateListener listener) {
        List<Battery.OnPluggedStateListener> list = this.mPluggedStateListeners;
        synchronized (list) {
            if (!this.mPluggedStateListeners.contains(listener)) {
                this.mPluggedStateListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnPluggedStateListener(@NonNull Battery.OnPluggedStateListener listener) {
        List<Battery.OnPluggedStateListener> list = this.mPluggedStateListeners;
        synchronized (list) {
            this.mPluggedStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBatteryReceiver(@NonNull Context context, int receiverFlag) {
        Object object = LOCK;
        synchronized (object) {
            if ((receiverFlag & 1) != 0 && !this.isBatteryReceiverRegistered(1)) {
                this.mStatusReceiver = new BatteryStatusReceiver();
                context.registerReceiver((BroadcastReceiver)this.mStatusReceiver, this.mStatusReceiver.newIntentFilter());
                this.mRegisteredReceivers.set(this.mRegisteredReceivers.get() | 1);
            }
            if ((receiverFlag & 2) != 0 && !this.isBatteryReceiverRegistered(2)) {
                this.mHealthReceiver = new BatteryHealthReceiver();
                context.registerReceiver((BroadcastReceiver)this.mHealthReceiver, this.mHealthReceiver.newIntentFilter());
                this.mRegisteredReceivers.set(this.mRegisteredReceivers.get() | 2);
            }
            if ((receiverFlag & 4) != 0 && !this.isBatteryReceiverRegistered(4)) {
                this.mPluggedStateReceiver = new BatteryPluggedStateReceiver();
                context.registerReceiver((BroadcastReceiver)this.mPluggedStateReceiver, this.mPluggedStateReceiver.newIntentFilter());
                this.mRegisteredReceivers.set(this.mRegisteredReceivers.get() | 4);
            }
        }
    }

    @Override
    public boolean isBatteryReceiverRegistered(int receiverFlag) {
        return (this.mRegisteredReceivers.get() & receiverFlag) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterBatteryReceiver(@NonNull Context context, int receiverFlag) {
        Object object = LOCK;
        synchronized (object) {
            if ((receiverFlag & 1) != 0 && this.isBatteryReceiverRegistered(1)) {
                context.unregisterReceiver((BroadcastReceiver)this.mStatusReceiver);
                this.mStatusReceiver = null;
                this.mRegisteredReceivers.set(this.mRegisteredReceivers.get() & 0xFFFFFFFE);
                this.mInfo.resetStatusData();
                this.mPrevInfo.resetStatusData();
                this.mDataInitialized = false;
                this.mPersistentDataInitialized = false;
                if (!this.isBatteryReceiverRegistered(2)) {
                    this.mInfo.resetHealthState();
                    this.mPrevInfo.resetHealthState();
                }
                if (!this.isBatteryReceiverRegistered(4)) {
                    this.mInfo.resetPluggedState();
                    this.mPrevInfo.resetPluggedState();
                }
            }
            if ((receiverFlag & 2) != 0 && this.isBatteryReceiverRegistered(2)) {
                context.unregisterReceiver((BroadcastReceiver)this.mHealthReceiver);
                this.mHealthReceiver = null;
                this.mRegisteredReceivers.set(this.mRegisteredReceivers.get() & 0xFFFFFFFD);
                if (!this.isBatteryReceiverRegistered(1)) {
                    this.mInfo.resetHealthState();
                    this.mPrevInfo.resetHealthState();
                }
            }
            if ((receiverFlag & 4) != 0 && this.isBatteryReceiverRegistered(4)) {
                context.unregisterReceiver((BroadcastReceiver)this.mPluggedStateReceiver);
                this.mPluggedStateReceiver = null;
                this.mRegisteredReceivers.set(this.mRegisteredReceivers.get() & 0xFFFFFFFB);
                if (!this.isBatteryReceiverRegistered(1)) {
                    this.mInfo.resetPluggedState();
                    this.mPrevInfo.resetPluggedState();
                }
            }
        }
    }

    void handleBroadcast(@NonNull Context context, @NonNull Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        Class receiverClass = (Class)intent.getSerializableExtra(Battery.BatteryBroadcastReceiver.EXTRA_RECEIVER_CLASS);
        if (BatteryStatusReceiver.class.equals((Object)receiverClass)) {
            this.bindBatteryData(intent);
            this.notifyBatteryStatusChange(context);
        } else if (BatteryHealthReceiver.class.equals((Object)receiverClass)) {
            this.notifyBatteryHealthChange(context, action.equals("android.intent.action.BATTERY_LOW"));
        } else if (BatteryPluggedStateReceiver.class.equals((Object)receiverClass)) {
            this.notifyBatteryPluggedStateChange(context, action.equals("android.intent.action.ACTION_POWER_CONNECTED"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatteryStatusChange(Context context) {
        List<Battery.OnStatusListener> list = this.mStatusListeners;
        synchronized (list) {
            if (!this.mStatusListeners.isEmpty()) {
                for (Battery.OnStatusListener listener : this.mStatusListeners) {
                    listener.onStatusChange(context, this);
                }
            }
        }
        if (this.mPrevInfo != null) {
            if (!this.isBatteryReceiverRegistered(2)) {
                switch (this.mPrevInfo.getHealthStatus(this.mInfo.strength())) {
                    case 2: {
                        this.notifyBatteryHealthChange(context, true);
                        break;
                    }
                    case 1: {
                        this.notifyBatteryHealthChange(context, false);
                        break;
                    }
                }
            }
            if (!this.isBatteryReceiverRegistered(4) && this.mPrevInfo.hasPluggedStateChanged(this.mInfo.pluggedState)) {
                this.notifyBatteryPluggedStateChange(context, this.isPlugged());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatteryHealthChange(Context context, boolean low) {
        List<Battery.OnHealthListener> list = this.mHealthListeners;
        synchronized (list) {
            if (!this.mHealthListeners.isEmpty()) {
                for (Battery.OnHealthListener listener : this.mHealthListeners) {
                    if (low) {
                        listener.onHealthLow(context, this);
                        continue;
                    }
                    listener.onHealthOk(context, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatteryPluggedStateChange(Context context, boolean plugged) {
        List<Battery.OnPluggedStateListener> list = this.mPluggedStateListeners;
        synchronized (list) {
            if (!this.mPluggedStateListeners.isEmpty()) {
                for (Battery.OnPluggedStateListener listener : this.mPluggedStateListeners) {
                    if (plugged) {
                        listener.onPluggedToPowerSource(context, this);
                        continue;
                    }
                    listener.onUnpluggedFromPowerSource(context, this);
                }
            }
        }
    }

    private final class BatteryInfo {
        static final int HEALTH_LEVEL_STATUS_UNCHANGED = 0;
        static final int HEALTH_LEVEL_STATUS_OK = 1;
        static final int HEALTH_LEVEL_STATUS_LOW = 2;
        int status = 1;
        int pluggedState = -1;
        Battery.BatteryTechnology technology = Battery.BatteryTechnology.UNKNOWN;
        int health = 1;
        float strength = -0.01f;
        int temperature = -1;
        int voltage = -1;

        BatteryInfo() {
        }

        BatteryInfo(BatteryInfo other) {
            this.health = other.health;
            this.status = other.status;
            this.pluggedState = other.pluggedState;
            this.technology = Battery.BatteryTechnology.resolve(other.technology.tagName);
            this.strength = other.strength;
            this.temperature = other.temperature;
            this.voltage = other.voltage;
        }

        void resetHealthState() {
            this.health = 1;
        }

        void resetPluggedState() {
            this.pluggedState = -1;
        }

        void resetStatusData() {
            this.status = 1;
            this.temperature = -1;
            this.strength = -1;
        }

        boolean hasPluggedStateChanged(int currentStatus) {
            return this.pluggedState != -1 && this.pluggedState != currentStatus;
        }

        int strength() {
            return (int)(((BatteryImpl)BatteryImpl.this).mInfo.strength * 100.0f);
        }

        int getHealthStatus(int currentHealthStrength) {
            int status = 0;
            int prevHealthStrength = this.strength();
            if (prevHealthStrength != currentHealthStrength) {
                if (prevHealthStrength == BatteryImpl.this.mHealthLowLevel + 1 && currentHealthStrength <= BatteryImpl.this.mHealthLowLevel) {
                    status = 2;
                } else if (prevHealthStrength == BatteryImpl.this.mHealthOkLevel && currentHealthStrength > BatteryImpl.this.mHealthOkLevel) {
                    status = 1;
                }
            }
            return status;
        }

        void logCurrentData() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(64);
            builder.append(BatteryInfo.class.getSimpleName());
            builder.append("{status: ");
            builder.append(this.status);
            builder.append(", health: ");
            builder.append(this.health);
            builder.append(", strength: ");
            builder.append(BatteryImpl.this.getStrength());
            builder.append(", voltage: ");
            builder.append(BatteryImpl.this.getVoltage());
            builder.append(", technology: ");
            builder.append(this.technology.name());
            builder.append(", pluggedState: ");
            builder.append(this.pluggedState);
            builder.append(", temperature: ");
            builder.append(BatteryImpl.this.getTemperature());
            return builder.append("}").toString();
        }
    }
}

