/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.device.battery;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.device.battery.BatteryImpl;

public interface Battery {
    public static final Provider PROVIDER = new Provider(){

        @Override
        @NonNull
        public Battery getBattery(@NonNull Context context) {
            return BatteryImpl.getInstance(context);
        }
    };
    public static final int RECEIVER_BATTERY_STATUS = 1;
    public static final int RECEIVER_BATTERY_HEALTH = 2;
    public static final int RECEIVER_BATTERY_PLUGGED_STATE = 4;
    public static final int STATUS_UNKNOWN = 1;
    public static final int STATUS_CHARGING = 2;
    public static final int STATUS_DISCHARGING = 3;
    public static final int STATUS_NOT_CHARGING = 4;
    public static final int STATUS_FULL = 5;
    public static final int PLUGGED_UNKNOWN = -1;
    public static final int PLUGGED_NONE = 0;
    public static final int PLUGGED_AC = 1;
    public static final int PLUGGED_USB = 2;
    public static final int PLUGGED_WIRELESS = 4;
    public static final int HEALTH_LOW_LEVEL = 15;
    public static final int HEALTH_OK_LEVEL = 20;
    public static final int HEALTH_UNKNOWN = 1;
    public static final int HEALTH_GOOD = 2;
    public static final int HEALTH_OVERHEAT = 3;
    public static final int HEALTH_DEAD = 4;
    public static final int HEALTH_OVER_VOLTAGE = 5;
    public static final int HEALTH_UNSPECIFIED_FAILURE = 6;
    public static final int HEALTH_COLD = 7;

    @IntRange(from=0L, to=100L)
    public int getStrength();

    public int getStatus();

    public int getPluggedState();

    public int getHealth();

    @NonNull
    public BatteryTechnology getTechnology();

    public float getTemperature();

    public int getVoltage();

    public boolean isCharging();

    public boolean isPlugged();

    public boolean isLow();

    public void setHealthLowLevel(@IntRange(from=0L, to=100L) int var1);

    @IntRange(from=0L, to=100L)
    public int getHealthLowLevel();

    public void setHealthOkLevel(int var1);

    public int getHealthOkLevel();

    public void registerOnStatusListener(@NonNull OnStatusListener var1);

    public void unregisterOnStatusListener(@NonNull OnStatusListener var1);

    public void registerOnHealthListener(@NonNull OnHealthListener var1);

    public void unregisterOnHealthListener(@NonNull OnHealthListener var1);

    public void registerOnPluggedStateListener(@NonNull OnPluggedStateListener var1);

    public void unregisterOnPluggedStateListener(@NonNull OnPluggedStateListener var1);

    public void registerBatteryReceiver(@NonNull Context var1, int var2);

    public boolean isBatteryReceiverRegistered(int var1);

    public void unregisterBatteryReceiver(@NonNull Context var1, int var2);

    public static abstract class BatteryBroadcastReceiver
    extends BroadcastReceiver {
        static final String EXTRA_RECEIVER_CLASS = Battery.class.getName() + ".EXTRA.ReceiverClass";

        @NonNull
        public abstract IntentFilter newIntentFilter();
    }

    public static enum BatteryTechnology {
        UNKNOWN("unknown", "unknown"),
        Li_ion("Li-ion", "Li-ion"),
        Li_poly("Li-poly", "Li-poly"),
        Ag_Zn("AgZn", "Ag-Zn"),
        Ni_Zn("NiZn", "Ni-Zn"),
        Ni_MH("NiMH", "Ni-MH"),
        LEAD_ACID("?", "Lead-acid"),
        Ni_Cd("NiCd", "Ni-Cd");

        public final String tagName;
        public final String originalName;

        private BatteryTechnology(String tagName, String origName) {
            this.tagName = tagName;
            this.originalName = origName;
        }

        @NonNull
        public static BatteryTechnology resolve(@NonNull String tagName) {
            for (BatteryTechnology tech : BatteryTechnology.values()) {
                if (!tech.tagName.equalsIgnoreCase(tagName)) continue;
                return tech;
            }
            return UNKNOWN;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Health {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PluggedState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Receiver {
    }

    public static interface OnHealthListener {
        public void onHealthOk(@NonNull Context var1, @NonNull Battery var2);

        public void onHealthLow(@NonNull Context var1, @NonNull Battery var2);
    }

    public static interface OnPluggedStateListener {
        public void onPluggedToPowerSource(@NonNull Context var1, @NonNull Battery var2);

        public void onUnpluggedFromPowerSource(@NonNull Context var1, @NonNull Battery var2);
    }

    public static interface OnStatusListener {
        public void onStatusChange(@NonNull Context var1, @NonNull Battery var2);
    }

    public static interface Provider {
        @NonNull
        public Battery getBattery(@NonNull Context var1);
    }
}

