/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.arkhitekton.control;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import universum.studios.android.arkhitekton.ArkhitektonLogging;
import universum.studios.android.arkhitekton.control.Controller;
import universum.studios.android.arkhitekton.interaction.Interactor;
import universum.studios.android.arkhitekton.view.presentation.Presenter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u0000 $*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003 \u0001*\u0006\u0012\u0002\b\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005:\u0003#$%B!\b\u0004\u0012\u0018\b\u0001\u0010\u0006\u001a\u0012\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0004J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\r\u0010\u0015\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u0017\u001a\u00028\u0001H\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0017J\b\u0010\u001e\u001a\u00020\u0012H\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0015J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u001aH\u0014J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006&"}, d2={"Luniversum/studios/android/arkhitekton/control/BaseController;", "I", "Luniversum/studios/android/arkhitekton/interaction/Interactor;", "P", "Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "Luniversum/studios/android/arkhitekton/control/Controller;", "builder", "Luniversum/studios/android/arkhitekton/control/BaseController$BaseBuilder;", "(Luniversum/studios/android/arkhitekton/control/BaseController$BaseBuilder;)V", "active", "Ljava/util/concurrent/atomic/AtomicBoolean;", "destroyed", "enabled", "interactor", "Luniversum/studios/android/arkhitekton/interaction/Interactor;", "presenter", "Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "activate", "", "assertActivated", "deactivate", "getInteractor", "()Luniversum/studios/android/arkhitekton/interaction/Interactor;", "getPresenter", "()Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "isActive", "", "isEnabled", "name", "", "onActivated", "onDeactivated", "onEnabledChanged", "setEnabled", "toString", "BaseBuilder", "Companion", "SimpleBuilder", "library_release"})
public abstract class BaseController<I extends Interactor, P extends Presenter<?>>
implements Controller<P> {
    private final I interactor;
    private final P presenter;
    private final AtomicBoolean active;
    private final AtomicBoolean enabled;
    private final AtomicBoolean destroyed;
    public static final Companion Companion = new Companion(null);

    @NonNull
    @NotNull
    public String name() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @Override
    public void activate() {
        boolean bl = !this.destroyed.get();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Deactivated controller cannot be activated again!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.active.compareAndSet(false, true)) {
            this.onActivated();
            ArkhitektonLogging.d$default(this.name(), "Activated.", null, 4, null);
        }
    }

    protected void onActivated() {
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    protected final void assertActivated() {
        boolean bl = this.active.get();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Not activated!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public void deactivate() {
        if (this.destroyed.get()) {
            return;
        }
        if (this.active.compareAndSet(true, false)) {
            this.onDeactivated();
            ArkhitektonLogging.d$default(this.name(), "Deactivated.", null, 4, null);
        }
        this.destroyed.set(true);
    }

    @CallSuper
    protected void onDeactivated() {
        this.presenter.destroy();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled.compareAndSet(!enabled, enabled)) {
            this.onEnabledChanged(enabled);
        }
    }

    protected void onEnabledChanged(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @NonNull
    @NotNull
    public final I getInteractor() {
        return this.interactor;
    }

    @Override
    @NonNull
    @NotNull
    public P getPresenter() {
        return this.presenter;
    }

    @NonNull
    @NotNull
    public String toString() {
        return this.name() + "(active: " + this.active + ", enabled: " + this.enabled + ')';
    }

    protected BaseController(@NonNull @NotNull BaseBuilder<?, I, P> builder) {
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        this.interactor = builder.getInteractor();
        this.presenter = builder.getPresenter();
        this.active = new AtomicBoolean(false);
        this.enabled = new AtomicBoolean(true);
        this.destroyed = new AtomicBoolean(false);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b&\u0018\u0000*\u001a\b\u0002\u0010\u0001*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0000*\b\b\u0003\u0010\u0002*\u00020\u0004*\f\b\u0004\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00052\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00070\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00028\u00022\u0006\u0010\t\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\u0019R\u001c\u0010\t\u001a\u00028\u0003X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u00028\u0004X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0015\u001a\u00028\u0002X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Luniversum/studios/android/arkhitekton/control/BaseController$BaseBuilder;", "B", "I", "P", "Luniversum/studios/android/arkhitekton/interaction/Interactor;", "Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "Luniversum/studios/android/arkhitekton/control/Controller$Builder;", "Luniversum/studios/android/arkhitekton/control/Controller;", "()V", "interactor", "getInteractor", "()Luniversum/studios/android/arkhitekton/interaction/Interactor;", "setInteractor", "(Luniversum/studios/android/arkhitekton/interaction/Interactor;)V", "Luniversum/studios/android/arkhitekton/interaction/Interactor;", "presenter", "getPresenter", "()Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "setPresenter", "(Luniversum/studios/android/arkhitekton/view/presentation/Presenter;)V", "Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "self", "getSelf", "()Luniversum/studios/android/arkhitekton/control/BaseController$BaseBuilder;", "(Luniversum/studios/android/arkhitekton/interaction/Interactor;)Luniversum/studios/android/arkhitekton/control/BaseController$BaseBuilder;", "(Luniversum/studios/android/arkhitekton/view/presentation/Presenter;)Luniversum/studios/android/arkhitekton/control/BaseController$BaseBuilder;", "library_release"})
    public static abstract class BaseBuilder<B extends BaseBuilder<B, I, P>, I extends Interactor, P extends Presenter<?>>
    implements Controller.Builder<Controller<? extends P>> {
        @NotNull
        public I interactor;
        @NotNull
        public P presenter;

        @NotNull
        protected abstract B getSelf();

        @NotNull
        public final I getInteractor() {
            I i = this.interactor;
            if (i == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"interactor");
            }
            return i;
        }

        public final void setInteractor(@NotNull I i) {
            Intrinsics.checkParameterIsNotNull(i, (String)"<set-?>");
            this.interactor = i;
        }

        @NotNull
        public final P getPresenter() {
            P p = this.presenter;
            if (p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
            }
            return p;
        }

        public final void setPresenter(@NotNull P p) {
            Intrinsics.checkParameterIsNotNull(p, (String)"<set-?>");
            this.presenter = p;
        }

        @NotNull
        public final B interactor(@NotNull I interactor) {
            Intrinsics.checkParameterIsNotNull(interactor, (String)"interactor");
            this.interactor = interactor;
            return this.getSelf();
        }

        @NotNull
        public final B presenter(@NotNull P presenter) {
            Intrinsics.checkParameterIsNotNull(presenter, (String)"presenter");
            this.presenter = presenter;
            return this.getSelf();
        }

        protected BaseBuilder() {
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f*\b\b\u0002\u0010\u0001*\u00020\u0002*\f\b\u0003\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0000\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00030\u000bH\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0000X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Luniversum/studios/android/arkhitekton/control/BaseController$SimpleBuilder;", "I", "Luniversum/studios/android/arkhitekton/interaction/Interactor;", "P", "Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "Luniversum/studios/android/arkhitekton/control/BaseController$BaseBuilder;", "()V", "self", "getSelf", "()Luniversum/studios/android/arkhitekton/control/BaseController$SimpleBuilder;", "build", "Luniversum/studios/android/arkhitekton/control/Controller;", "Companion", "library_release"})
    public static final class SimpleBuilder<I extends Interactor, P extends Presenter<?>>
    extends BaseBuilder<SimpleBuilder<I, P>, I, P> {
        @NotNull
        private final SimpleBuilder<I, P> self = this;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        protected SimpleBuilder<I, P> getSelf() {
            return this.self;
        }

        @Override
        @NotNull
        public Controller<P> build() {
            throw (Throwable)new UnsupportedOperationException("Pass instance of SimpleBuilder to the appropriate constructor!");
        }

        private SimpleBuilder() {
        }

        public /* synthetic */ SimpleBuilder(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        @NotNull
        public static final <I extends Interactor, P extends Presenter<?>> SimpleBuilder<I, P> create(@NonNull @NotNull I interactor, @NonNull @NotNull P presenter) {
            return Companion.create(interactor, presenter);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\b\b\u0004\u0010\u0005*\u00020\u0007\"\f\b\u0005\u0010\u0006*\u0006\u0012\u0002\b\u00030\b2\b\b\u0001\u0010\t\u001a\u0002H\u00052\b\b\u0001\u0010\n\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Luniversum/studios/android/arkhitekton/control/BaseController$SimpleBuilder$Companion;", "", "()V", "create", "Luniversum/studios/android/arkhitekton/control/BaseController$SimpleBuilder;", "I", "P", "Luniversum/studios/android/arkhitekton/interaction/Interactor;", "Luniversum/studios/android/arkhitekton/view/presentation/Presenter;", "interactor", "presenter", "(Luniversum/studios/android/arkhitekton/interaction/Interactor;Luniversum/studios/android/arkhitekton/view/presentation/Presenter;)Luniversum/studios/android/arkhitekton/control/BaseController$SimpleBuilder;", "library_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final <I extends Interactor, P extends Presenter<?>> SimpleBuilder<I, P> create(@NonNull @NotNull I interactor, @NonNull @NotNull P presenter) {
                Intrinsics.checkParameterIsNotNull(interactor, (String)"interactor");
                Intrinsics.checkParameterIsNotNull(presenter, (String)"presenter");
                SimpleBuilder<I, P> simpleBuilder = new SimpleBuilder<I, P>(null);
                boolean bl = false;
                boolean bl2 = false;
                SimpleBuilder<I, P> $this$apply = simpleBuilder;
                boolean bl3 = false;
                $this$apply.setInteractor(interactor);
                $this$apply.setPresenter(presenter);
                return simpleBuilder;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Luniversum/studios/android/arkhitekton/control/BaseController$Companion;", "", "()V", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

