/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.arkhitekton.interaction.usecase;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import universum.studios.android.arkhitekton.interaction.Request;
import universum.studios.android.arkhitekton.interaction.Response;
import universum.studios.android.arkhitekton.interaction.Responses;
import universum.studios.android.arkhitekton.interaction.usecase.UseCase;
import universum.studios.android.arkhitekton.util.Error;
import universum.studios.android.arkhitekton.util.ExecutionUtils;
import universum.studios.android.arkhitekton.util.Requirements;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u001e*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0002\u001d\u001eB\u0015\b\u0004\u0012\f\b\u0001\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00028\u00002\b\b\u0003\u0010\u0011\u001a\u00020\u0012H\u0005\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00028\u00002\b\b\u0001\u0010\u0015\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u001c\u001a\u00020\u001aH\u0017R\u001c\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Luniversum/studios/android/arkhitekton/interaction/usecase/BaseUseCase;", "Request", "Luniversum/studios/android/arkhitekton/interaction/Request;", "ResultValue", "Luniversum/studios/android/arkhitekton/interaction/usecase/UseCase;", "builder", "Luniversum/studios/android/arkhitekton/interaction/usecase/BaseUseCase$BaseBuilder;", "(Luniversum/studios/android/arkhitekton/interaction/usecase/BaseUseCase$BaseBuilder;)V", "minExecutionDuration", "", "minExecutionDuration$annotations", "()V", "getMinExecutionDuration$library_release", "()J", "createFailure", "Luniversum/studios/android/arkhitekton/interaction/Response;", "request", "error", "Luniversum/studios/android/arkhitekton/util/Error;", "(Luniversum/studios/android/arkhitekton/interaction/Request;Luniversum/studios/android/arkhitekton/util/Error;)Luniversum/studios/android/arkhitekton/interaction/Response;", "createSuccess", "resultValue", "(Luniversum/studios/android/arkhitekton/interaction/Request;Ljava/lang/Object;)Luniversum/studios/android/arkhitekton/interaction/Response;", "execute", "(Luniversum/studios/android/arkhitekton/interaction/Request;)Luniversum/studios/android/arkhitekton/interaction/Response;", "name", "", "onExecute", "toString", "BaseBuilder", "Companion", "library_release"})
public abstract class BaseUseCase<Request extends Request, ResultValue>
implements UseCase<Request, ResultValue> {
    private final long minExecutionDuration;
    public static final long IMMEDIATE_EXECUTION = 0L;
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void minExecutionDuration$annotations() {
    }

    public final long getMinExecutionDuration$library_release() {
        return this.minExecutionDuration;
    }

    @NonNull
    @NotNull
    public String name() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @Override
    @NotNull
    public Response<ResultValue> execute(@NonNull @NotNull Request request) {
        Response<ResultValue> response;
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        if (this.minExecutionDuration == 0L) {
            response = this.onExecute(request);
        } else {
            long startTime = System.currentTimeMillis();
            Response<ResultValue> response2 = this.onExecute(request);
            long executionDuration = System.currentTimeMillis() - startTime;
            if (executionDuration < this.minExecutionDuration) {
                ExecutionUtils.sleepFor(this.minExecutionDuration - executionDuration);
            }
            response = response2;
        }
        return response;
    }

    @NotNull
    protected abstract Response<ResultValue> onExecute(@NonNull @NotNull Request var1);

    @NotNull
    protected final Response<ResultValue> createSuccess(@NonNull @NotNull Request request, @NonNull ResultValue resultValue) {
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        return Responses.createSuccess(request, resultValue);
    }

    @JvmOverloads
    @NotNull
    protected final Response<ResultValue> createFailure(@NonNull @NotNull Request request, @NonNull @NotNull Error error) {
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        return Responses.createFailure(request, error);
    }

    public static /* synthetic */ Response createFailure$default(BaseUseCase baseUseCase, Request request, Error error, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createFailure");
        }
        if ((n & 2) != 0) {
            error = Error.Contract.unknown();
        }
        return baseUseCase.createFailure(request, error);
    }

    @JvmOverloads
    @NotNull
    protected final Response<ResultValue> createFailure(@NonNull @NotNull Request request) {
        return BaseUseCase.createFailure$default(this, request, null, 2, null);
    }

    @NonNull
    @NotNull
    public String toString() {
        return this.name() + "(minExecutionDuration: " + this.minExecutionDuration + ')';
    }

    protected BaseUseCase(@NonNull @NotNull BaseBuilder<?> builder) {
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        this.minExecutionDuration = Requirements.requireNonNegative(builder.getMinExecutionDuration(), "Min execution duration must be non-negative!");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\b&\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00030\u0002B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00028\u00022\b\b\u0001\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00028\u0002X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Luniversum/studios/android/arkhitekton/interaction/usecase/BaseUseCase$BaseBuilder;", "B", "Luniversum/studios/android/arkhitekton/interaction/usecase/UseCase$Builder;", "Luniversum/studios/android/arkhitekton/interaction/usecase/UseCase;", "()V", "minExecutionDuration", "", "getMinExecutionDuration", "()J", "setMinExecutionDuration", "(J)V", "self", "getSelf", "()Luniversum/studios/android/arkhitekton/interaction/usecase/BaseUseCase$BaseBuilder;", "duration", "(J)Luniversum/studios/android/arkhitekton/interaction/usecase/BaseUseCase$BaseBuilder;", "library_release"})
    public static abstract class BaseBuilder<B extends BaseBuilder<B>>
    implements UseCase.Builder<UseCase<?, ?>> {
        private long minExecutionDuration;

        public final long getMinExecutionDuration() {
            return this.minExecutionDuration;
        }

        public final void setMinExecutionDuration(long l) {
            this.minExecutionDuration = l;
        }

        @NotNull
        protected abstract B getSelf();

        @NotNull
        public final B minExecutionDuration(@IntRange(from=0L) long duration) {
            this.minExecutionDuration = duration;
            return this.getSelf();
        }

        protected BaseBuilder() {
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Luniversum/studios/android/arkhitekton/interaction/usecase/BaseUseCase$Companion;", "", "()V", "IMMEDIATE_EXECUTION", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

