/*
 * *************************************************************************************************
 *                                 Copyright 2018 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.arkhitekton.util

import androidx.annotation.NonNull

/**
 * Convenient implementation of [Throwable] which provides simple [NONE][Cause.NONE] instance.
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
open class Cause : Throwable("") {

    /**
     * Contract for [Cause] element.
     */
    companion object Contract {

        /**
         * Instance of [Throwable] which may be used as empty object to indicate no particular cause.
         */
        @NonNull @JvmField val NONE: Throwable = object : Cause() {

            /*
             */
            @NonNull override fun toString() = "NONE"
        }
    }
}