/*
 * *************************************************************************************************
 *                                 Copyright 2018 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */

package universum.studios.android.arkhitekton.handler;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.Nullable;

/**
 * todo:
 *
 * @author Martin Albedinsky
 */
public interface ActivityResultHandler {

	/**
	 * Called from the activity result aware context that has received the given result <var>data</var>
	 * associated with the <var>requestCode</var>.
	 *
	 * @param requestCode Request code of the result.
	 * @param resultCode  Result code of the result. May be one of {@link Activity#RESULT_OK},
	 *                    {@link Activity#RESULT_FIRST_USER} or {@link Activity#RESULT_CANCELED}.
	 * @param data        The data of the result. May be {@code null} if no data has been delivered.
	 * @return {@code True} if the dispatched activity result has been processed by this handler,
	 * {@code false} if not and should be passed for processing to another handler or to be processed
	 * by the context itself.
	 */
	boolean handleActivityResult(int requestCode, int resultCode, @Nullable Intent data);
}