/*
 * *************************************************************************************************
 *                                 Copyright 2018 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.arkhitekton.interaction

import android.support.annotation.NonNull

/**
 * Basic interface describing result which may be carried by [Response].
 *
 * @author Martin Albedinsky
 * @since 1.0
 *
 * @see Response.getResult
 */
interface Result {

    /*
	 * Companion ===================================================================================
	 */

    /**
     * Contract for [Result] element.
     */
    companion object Contract {

        /**
         * Empty instance without any data.
         */
        @NonNull internal val EMPTY: Empty = object : Empty {}

        /**
         * Returns an instance of empty result which has no data.
         *
         * @return Empty result ready to be attached to a desired response.
         */
        @NonNull fun empty() = EMPTY
    }

    /*
     * Interface ===================================================================================
     */

    /**
     * A [Result] extension which may be used to indicate that a particular [Response] will cary an
     * empty result, that is, without any data.
     *
     * @author Martin Albedinsky
     * @since 1.0
     *
     * @see empty
     */
    interface Empty : Result

    /*
     * Functions ===================================================================================
     */
}