/*
 * *************************************************************************************************
 *                                 Copyright 2018 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.arkhitekton.view.presentation

import android.support.annotation.NonNull
import io.reactivex.Scheduler
import io.reactivex.android.schedulers.AndroidSchedulers

/**
 * Static source for reactive schedulers for **presentation** elements.
 *
 * @author Martin Albedinsky
 * @since 1.0
 *
 * @see PresentationSchedulers.primaryScheduler
 */
class PresentationSchedulers private constructor() {

    /**
     */
    companion object {

        /**
         * Scheduler that should be used for primary presentations.
         */
        private var primaryScheduler: Scheduler = AndroidSchedulers.mainThread()

        /**
         * Specifies a scheduler that should be used for primary presentation logic.
         *
         * @param scheduler The desired scheduler to be used across library.
         *
         * @see primaryScheduler
         */
        @JvmStatic fun setPrimaryScheduler(@NonNull scheduler: Scheduler) {
            this.primaryScheduler = scheduler
        }

        /**
         * Returns the scheduler that should be used for primary presentation logic.
         *
         * Default value: [AndroidSchedulers.mainThread]
         *
         * @return Primary scheduler ready to be used.
         *
         * @see setPrimaryScheduler
         */
        @Deprecated("Use primaryScheduler() instead.", replaceWith = ReplaceWith("PresentationSchedulers.primaryScheduler()"))
        @JvmStatic @NonNull fun getPrimaryScheduler(): Scheduler = primaryScheduler()

        /**
         * Returns the scheduler that should be used for primary presentation logic.
         *
         * Default value: [AndroidSchedulers.mainThread]
         *
         * @return Primary scheduler ready to be used.
         *
         * @see setPrimaryScheduler
         */
        @JvmStatic @NonNull fun primaryScheduler(): Scheduler = primaryScheduler
    }

    /**
     */
    init {
        // Not allowed to be instantiated publicly.
        throw UnsupportedOperationException()
    }
}