/*
 * *************************************************************************************************
 *                                 Copyright 2018 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.arkhitekton.interaction.usecase

import android.support.annotation.NonNull
import universum.studios.android.arkhitekton.util.Failure

/**
 * Factory class which may be used to create [UseCaseResponse] instances.
 *
 * @author Martin Albedinsky
 * @since 1.0
 *
 * @see UseCaseResponses.createSuccess
 * @see UseCaseResponses.createFailure
 */
@Deprecated("Use Responses instead!", replaceWith = ReplaceWith("Responses"))
class UseCaseResponses private constructor() {

    /**
     */
    companion object {

        /**
         * Convenience method which creates instance of [UseCaseResponse] with
         * [EMPTY][UseCaseResult.empty] result.
         *
         * @param request  Request for which is the new response being created. Default is [EMPTY][UseCaseRequest.empty].
         * @return Success response ready to be dispatched.
         *
         * @see createSuccess
         */
        @Deprecated("Use Responses.createEmptySuccess() instead!", replaceWith = ReplaceWith("Responses.createEmptySuccess(request)"))
        @JvmStatic @JvmOverloads @NonNull fun createEmptySuccess(@NonNull request: UseCaseRequest = UseCaseRequest.empty()): UseCaseResponse<UseCaseResult.Empty> {
            return createSuccess(request, UseCaseResult.empty())
        }

        /**
         * Creates a new instance of successful [UseCaseResponse] with the specified `result`.
         *
         * @param request Request for which is the new response being created.
         * @param result Result of the processed request.
         * @param Result Type of the response result.
         * @return Use case response ready to be dispatched.
         *
         * @see createEmptySuccess
         * @see createFailure
         */
        @Deprecated("Use Responses.createSuccess() instead!", replaceWith = ReplaceWith("Responses.createSuccess(request, result)"))
        @JvmStatic @NonNull fun <Result> createSuccess(@NonNull request: UseCaseRequest, @NonNull result: Result): UseCaseResponse<Result> {
            return UseCaseResponseImpl.Builder<Result>(request).result(result).build()
        }

        /**
         * Convenience method which creates instance of [UseCaseResponse] with
         * [UNKNOWN][Failure.unknown] failure.
         *
         * @param request Request for which is the new response being created. Default is [EMPTY][UseCaseRequest.empty].
         * @param Result Type of the response result.
         * @return Failed response ready to be dispatched.
         *
         * @see createFailure
         */
        @Deprecated("Use Responses.createUnknownFailure() instead!", replaceWith = ReplaceWith("Responses.createUnknownFailure(request)"))
        @JvmStatic @JvmOverloads @NonNull fun <Result> createUnknownFailure(@NonNull request: UseCaseRequest = UseCaseRequest.empty()): UseCaseResponse<Result> {
            return createFailure(request, Failure.unknown())
        }

        /**
         * Creates a new instance of [UseCaseResponse] with the specified `failure`.
         *
         * @param request Request for which is the new response being created.
         * @param failure Failure due to which the request has failed.
         * @param Result Type of the response result.
         * @return Use case response ready to be dispatched.
         *
         * @see createUnknownFailure
         * @see createSuccess
         */
        @Deprecated("Use Responses.createFailure() instead!", replaceWith = ReplaceWith("Responses.createFailure(request, failure)"))
        @JvmStatic @NonNull fun <Result> createFailure(@NonNull request: UseCaseRequest, @NonNull failure: Failure): UseCaseResponse<Result> {
            return UseCaseResponseImpl.Builder<Result>(request).failure(failure).build()
        }
    }

    /**
     */
    init {
        // Not allowed to be instantiated publicly.
        throw UnsupportedOperationException()
    }
}